<!DOCTYPE html>
<html>

<head>
    <?php echo $__env->make('head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <style>
        @media (max-width: 600px) {
            .btn-cad {

                margin-left: -188px;

            }

        }
    </style>

</head>

<body>
    <!-- <form class="form-vertical form-bordered" name="myForm" method="POST"> -->
    <!-- begin #page-loader -->
    <div id="page-loader" class="fade in"><span class="spinner"></span></div>
    <!-- end #page-loader -->

    <!-- begin #page-container -->
    <div id="page-container" class="fade page-sidebar-fixed page-header-fixed">
        <?php echo $__env->make('topo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- begin #header -->
        <!-- end #sidebar -->

        <!-- begin #content -->
        <div id="content" class="content">
            <?php if(\Session::has('success')): ?>
            <div class="alert alert-success  fade in">
                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                <h4 style="box-sizing: border-box;"><?php echo \Session::get('success'); ?></h4>
            </div>
            <?php endif; ?>

            <?php if(\Session::has('error')): ?>
            <div class="alert alert-danger  fade in">
                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                <h4 style="box-sizing: border-box;"><?php echo \Session::get('error'); ?></h4>
            </div>
            <?php endif; ?>


            <h1 class="page-header">Cadastro de Conta Corrente</h1>

            <div class="row">
                <div class="col-md-12">
                    <div class="panel panel-inverse">
                        <div class="panel-heading">
                            <div class="panel-heading-btn">
                                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-default" data-click="panel-expand"><i class="fa fa-expand"></i></a>
                                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-success" data-click="panel-reload"><i class="fa fa-repeat"></i></a>
                                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-warning" data-click="panel-collapse"><i class="fa fa-minus"></i></a>
                                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-danger" data-click="panel-remove"><i class="fa fa-times"></i></a>
                            </div>
                            <h4 class="panel-title">Preencha os dados.</h4>
                        </div>

                        <div class="panel-body">
                            <form action="<?php echo url('/criar_conta_corrente'); ?>" method="POST" data-parsley-validate="true" name="form_wizard">
                                <?php echo e(csrf_field()); ?>

                                <input type="hidden" name="cadastrado_por" value="<?php echo e(Auth::user()->id); ?>">

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Banco</label>
                                            <div class="controls">
                                                <select name="banco" class="form-control" id="banco_id" onchange="dados_banco()" required="">
                                                    <option value="001">Banco do Brasil (240)</option>
                                                    <option value="237">Bradesco (240)</option>
                                                    <option value="104">Caixa (240)</option>
                                                    <option value="033">Santander (240)</option>
                                                    <option value="756">Sicoob (240)</option>
                                                    <option value="748">Sicredi (240)</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Empresa</label>
                                            <div class="controls">
                                                <select class="default-select2 form-control" name="cliente_idcliente" required="">
                                                    <option value="">Escolha</option>
                                                    <?php $__currentLoopData = $empreendimentos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empreendimento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                    <option value="<?php echo e($empreendimento->idcliente); ?>"><?php echo e($empreendimento->nome_cli); ?> CPF : <?php echo e($empreendimento->cpf_cli); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Agência</label>
                                            <div class="controls" style="display: flex; flex-direction: row;">
                                                <input type="text" class="form-control" name="agencia" required="" style="width: 50%;" />
                                                <label for="">&nbsp;<strong>_</strong>&nbsp;</label>

                                                <input type="text" class="form-control" name="dig_agencia" maxlength="1" required="" style="width: 15%;" />
                                            </div>
                                        </div>
                                    </div>
                                    <!-- begin col-4 -->


                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Nº da Conta</label>
                                            <div class="controls" style="display: flex; flex-direction: row;">
                                                <input type="text" class="form-control" name="conta" equired="" style="width: 50%;" />
                                                <label for="">&nbsp;<strong>_</strong>&nbsp;</label>
                                                <input type="text" class="form-control" name="dig_conta" maxlength="1" required="" style="width: 15%;" />
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Carteira</label>
                                            <div class="controls">
                                                <input type="text" class="form-control" name="carteira" required="" />

                                            </div>
                                        </div>
                                    </div>

                                </div>


                                <!-- begin col-4 -->

                                <!-- end col-6 -->

                                <div class="row">
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>Cod Cedente / Beneficiario</label>
                                            <div class="controls">
                                                <input type="text" class="form-control" name="codigo_cedente" required="" />

                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4" id="posto_id" style="display: none">
                                        <div class="form-group">
                                            <label>Posto (Sicredi)</label>
                                            <div class="controls">
                                                <input type="text" class="form-control" name="posto" />

                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4" id="chave_id" style="display: none">
                                        <div class="form-group">
                                            <label>Chave Master (Sicredi)</label>
                                            <div class="controls">
                                                <input type="text" class="form-control" name="chave_master" />

                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4" id="transmissao_id" style="display: none">
                                        <div class="form-group">
                                            <label>Cod Transmissão (Santander) </label>
                                            <div class="controls">
                                                <input type="text" class="form-control" name="cod_transmissao" id="cod_transmissao" />

                                            </div>
                                        </div>
                                    </div>


                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>Dias para baixa </label>
                                            <div class="controls">
                                                <input type="number" class="form-control" name="dias_baixa_banco" />

                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Quem Envia </label>
                                            <div class="controls">
                                                <select class="form-control" name="quem_envia">
                                                    <option value="0">Cliente Envia Boletos</option>
                                                    <option value="1">Banco Envia Boletos</option>
                                                </select>

                                            </div>
                                        </div>
                                    </div>
                                    

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Descrição Conta </label>
                                            <div class="controls">
                                                <input type="text" class="form-control" required name="descricao_conta" placeholder="Ex: Conta Santander 2" />

                                            </div>
                                        </div>
                                    </div>




                                </div>



                                </fieldset>
                                <div class="text-right block3">

                                    <p><input type="submit" class="btn btn-success btn-lg " id="cadastrar" role="button" value="Cadastrar" /></p>
                                </div>
                        </div>


                    </div>
                    </form>
                </div>
            </div>

        </div>

        <!-- end col-10 -->
    </div>
    <!-- end row -->
    </div>
    <!-- end #content -->

    <!-- begin scroll to top btn -->
    <a href="javascript:;" class="btn btn-icon btn-circle btn-success btn-scroll-to-top fade" data-click="scroll-top"><i class="fa fa-angle-up"></i></a>
    <!-- end scroll to top btn -->
    </div>

    <?php echo $__env->make('script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        function dados_banco() {
            var x = document.getElementById("banco_id").value;
            if (x == '033') {
                document.getElementById("transmissao_id").style.display = "block";
                document.getElementById("cod_transmissao").setAttribute('required', 'required');
            }
            if (x == '001' || x == '237' || x == '104' || x == '756') {
                document.getElementById("transmissao_id").style.display = "none";
                document.getElementById("chave_id").style.display = "none";
                document.getElementById("posto_id").style.display = "none";

            }
            if (x == '748') {
                document.getElementById("posto_id").style.display = "block";
                document.getElementById("posto_id").setAttribute('required', 'required');

                document.getElementById("chave_id").style.display = "block";
                document.getElementById("chave_id").setAttribute('required', 'required');

            }
        }
    </script>

    <script>

        $(document).ready(function() {
            App.init();
            TableManageButtons.init();
            FormPlugins.init();
        });
    </script>
    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
    </script>

</body>

</html><?php /**PATH C:\xampp\htdocs\light\resources\views/configuracoes/cadastrar_conta.blade.php ENDPATH**/ ?>