<!DOCTYPE html>
<html>

<head>
    @include ('head')
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <style>
        @media (max-width: 600px) {
            .btn-cad {

                margin-left: -188px;

            }

        }

        #visualizar {
            max-width: 150px;
            margin: 15px;
            border-radius: 5px;
        }

        input[type='file'] {
            display: none
        }

        #sel_arquivo {
            background-color: #00acac;
            border-radius: 5px;
            color: #fff;
            cursor: pointer;
            margin: 10px;
            padding: 6px 20px
        }
    </style>

</head>

<body>
    <!-- @foreach($empreendimentos as $empreendimento) -->
    <!-- <form class="form-vertical form-bordered" name="myForm" method="POST"> -->
    <!-- begin #page-loader -->
    <div id="page-loader" class="fade in"><span class="spinner"></span></div>
    <!-- end #page-loader -->

    <!-- begin #page-container -->
    <div id="page-container" class="fade page-sidebar-fixed page-header-fixed">
        @include ('topo')
        <!-- begin #header -->
        <!-- end #sidebar -->

        <!-- begin #content -->
        <div id="content" class="content">
            @if (\Session::has('success'))
            <div class="alert alert-success  fade in">
                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                <h4 style="box-sizing: border-box;">{!! \Session::get('success') !!}</h4>
            </div>
            @endif

            @if (\Session::has('error'))
            <div class="alert alert-danger  fade in">
                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                <h4 style="box-sizing: border-box;">{!! \Session::get('error') !!}</h4>
            </div>
            @endif
            <h1 class="page-header">Anexos de imagens</h1>

            <div class="row">
                <div class="col-md-12">
                    <div class="panel panel-inverse">
                        <div class="panel-heading">
                            <div class="panel-heading-btn">
                                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-default" data-click="panel-expand"><i class="fa fa-expand"></i></a>
                                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-success" data-click="panel-reload"><i class="fa fa-repeat"></i></a>
                                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-warning" data-click="panel-collapse"><i class="fa fa-minus"></i></a>
                                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-danger" data-click="panel-remove"><i class="fa fa-times"></i></a>
                            </div>
                            <h4 class="panel-title">Anexar imagens</h4>
                        </div>
                        <div class="panel-body">
                            <label><Strong>Máximo de 15 arquivos por envio - Tamanho máximo: 6Mb</Strong></label>


                            <form method="post" action="{{URL('fotos_emp', $empreendimento->idempreendimento_cadastro)}}" enctype="multipart/form-data" class="dropzone" id="dropzone">
                                <!-- {{ csrf_field() }} -->


                                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                            </form>
                            <div style="margin-top: 25px;" align="center">
                                <button type="button" class="btn btn-info" id="submit-all">Enviar</button>
                            </div>
                        </div>

                        <!-- Script -->

                    </div>
                </div>
                <a href="javascript:;" class="btn btn-icon btn-circle btn-success btn-scroll-to-top fade" data-click="scroll-top"><i class="fa fa-angle-up"></i></a>
            </div>
            <div class="panel panel-inverse">
                <div class="panel-heading">
                    <div class="panel-heading-btn">
                        <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-default" data-click="panel-expand"><i class="fa fa-expand"></i></a>
                        <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-success" data-click="panel-reload"><i class="fa fa-repeat"></i></a>
                        <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-warning" data-click="panel-collapse"><i class="fa fa-minus"></i></a>
                        <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-danger" data-click="panel-remove"><i class="fa fa-times"></i></a>
                    </div>
                    <h4 class="panel-title">Imagens enviadas</h4>
                </div>
                <div class="panel-body">
                    <table id="data-table" class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>Código</th>
                                <th>Visualizar</th>
                                <th>Nome do arquivo</th>
                                <th>Ações</th>

                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                @foreach($fotos as $foto)
                            <tr class="odd gradeX">
                                <td>{{$foto->idfotos_empreendimento}}</td>
                                <td><a href="{{url('storage/'. $foto->url_img)}}"><img src="{{url('storage/'. $foto->url_img)}}" style="width: 35px; cursor: pointer;" class=”magnify” id="img_visual" alt=""></a></td>
                                <td>@if($empreendimento->img_lote == $foto->url_img)<strong> (Principal) </strong>@endif {{$foto->nome_original_foto}}</td>

                                <td style="cursor: pointer;">

                                    <!-- <a href="{{URL('/editar_foto', $empreendimento->idempreendimento_cadastro)}}"> <span class="label label-warning">Editar</span></a> -->
                                    <a style="cursor: pointer;" class="editar" id="{{$empreendimento->idempreendimento_cadastro}}" name="{{$foto->url_img}}"> <span @if($empreendimento->img_lote == $foto->url_img) style="background-color:#8E12D6;"@endif class="label label-info"> @if($empreendimento->img_lote == $foto->url_img)<strong> Principal </strong> @else Definir como principal @endif </span></a>&nbsp;

                                    <a style="cursor: pointer;" class="delete" id="{{$foto->idfotos_empreendimento}}"><span class="label label-danger">Excluir imagem</span></a>

                                </td>

                                @endforeach



                                <div class="modal fade" id="modal_excluir" role="dialog">
                                    <div class="modal-dialog modal-xs">

                                        <div class="modal-content">


                                            <style>
                                                .excluir {
                                                    background-color: #1a2229;
                                                    margin-top: -30px;
                                                }

                                                .excluir_mod {
                                                    color: white;
                                                    font-weight: bold;
                                                }

                                                .excluir_mod:hover {
                                                    color: black;
                                                    font-weight: bold;
                                                }

                                                .text-center {
                                                    background-color: #BD0900;
                                                    color: white;
                                                    padding: 15px;
                                                    box-sizing: border-box;
                                                    border-radius: 4px;
                                                }

                                                .pull-left {
                                                    font-size: 16px;
                                                }
                                            </style>

                                            <div class="modal-body">
                                                <legend class="text-center block2">Excluir imagem </legend>



                                                <div style="margin-bottom: 0px;" class="tab-content">

                                                    <div id="excluir" class="tab-pane fade in active">
                                                        <form method="POST" class="form-del" id="delete_form_modal">

                                                            <meta name="csrf-token" content="{{ csrf_token() }}">
                                                            <fieldset>
                                                                <legend class="pull-left width-full">Deseja realmente excluir a imagem selecionado? </legend>
                                                            </fieldset>


                                                            <div class="text-right block3">
                                                                <button type="button" class="btn btn-danger" name="deleteModal" id="deleteModal">Sim, desejo excluir!</button>
                                                                <button type="button" class="btn btn-secondary" name="del" id="del" data-toggle="modal" data-target="#modal_excluir">Cancelar</button>

                                                            </div>

                                                        </form>
                                                    </div>



                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>



                        </tbody>
                    </table>
                </div>
                <a href="javascript:;" class="btn btn-icon btn-circle btn-success btn-scroll-to-top fade" data-click="scroll-top"><i class="fa fa-angle-up"></i></a>
            </div>

            @include ('script')

            <script>
                var url_img;
                var id;
                $(document).on('click', '.editar', function() {
                    var url_img = $(this).attr('name');
                    var id = $(this).attr('id');
                    // var url_img = $("#url_img").val();
                    // var id = $("#id_user").val();

                    $.ajax({
                        url: "/marcarimagem/" + id,
                        type: 'POST',
                        data: 'id_user=' + id + '&url_img=' + url_img,
                        success: function(data) {
                            setTimeout(function() {
                                location.reload();

                            });
                        }


                    });
                    console.log(url_img);
                    console.log(id);

                })
            </script>
            <script>
                var user_id;
                $(document).on('click', '.delete', function() {
                    user_id = $(this).attr('id');
                    $('#modal_excluir').modal('show');
                });
                $('#deleteModal').click(function() {
                    $.ajax({
                        url: "/fotos/delete/ " + user_id,
                        type: 'POST',

                        beforeSend: function() {
                            $('#deleteModal').text('Deletando...');
                        },
                        success: function(data) {
                            setTimeout(function() {
                                location.reload();

                            });

                        }
                    });
                });
            </script>
            <script>
                var user_id;
                $(document).on('click', '.editar', function() {
                    user_id = $(this).attr('id');
                    $('#modal_editar').modal('show');
                    $('#id_foto').val('Testando');

                });
                // $('#deleteModal').click(function() {
                //     $.ajax({
                //         url: "/fotos/delete/ " + user_id,
                //         type: 'POST',

                //         beforeSend: function() {
                //             $('#deleteModal').text('Deletando...');
                //         },
                //         success: function(data) {
                //             setTimeout(function() {
                //                 location.reload();

                //             });

                //         }
                //     });
                // });
            </script>
            <script type="text/javascript">
                Dropzone.options.dropzone = {
                    method: 'POST',
                    autoProcessQueue: false,
                    // acceptedFiles: ".png,.jpg,.jpeg,.pdf,.js,.rar",
                    addRemoveLinks: true,
                    maxFiles: 15,
                    maxFilesize: 6,

                    init: function() {
                        var submitButton = document.querySelector("#submit-all");
                        myDropzone = this;

                        submitButton.addEventListener('click', function() {
                            myDropzone.processQueue();
                        });
                        this.on("complete", function() {
                            if (this.getQueuedFiles().length == 0 && this.getUploadingFiles().length == 0) {
                                var _this = this;
                                _this.removeAllFiles();
                            }

                        });

                    },
                    success: function(data) {

                        location.reload();
                        // swal("Sucesso!", "Anexo inserido com sucesso.", "success");
                    }
                };
            </script>
            <script>
                function readURL(input) {
                    if (input.files && input.files[0]) {
                        var reader = new FileReader();

                        reader.onload = function(e) {
                            $('#visualizar').attr('src', e.target.result);
                        }

                        reader.readAsDataURL(input.files[0]);
                    }
                }

                $("#selecao-arquivo").change(function() {
                    readURL(this);
                });
                $(document).ready(function() {
                    App.init();
                    TableManageButtons.init();
                    FormPlugins.init();
                });
            </script>
            <script>
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
            </script>
            <!-- @endforeach -->
</body>

</html>