<!DOCTYPE html>
<html>

<head>
    @include ('head')
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <style>
        @media (max-width: 600px) {
            .btn-cad {

                margin-left: -188px;

            }

        }

        #visualizar {
            max-width: 150px;
            margin: 15px;
            border-radius: 5px;
        }

        input[type='file'] {
            display: none
        }

        #sel_arquivo {
            background-color: #00acac;
            border-radius: 5px;
            color: #fff;
            cursor: pointer;
            margin: 10px;
            padding: 6px 20px
        }
    </style>

</head>

<body>
    <!-- @foreach($empreendimentos as $empreendimento) -->
    <!-- <form class="form-vertical form-bordered" name="myForm" method="POST"> -->
    <!-- begin #page-loader -->
    <div id="page-loader" class="fade in"><span class="spinner"></span></div>
    <!-- end #page-loader -->

    <!-- begin #page-container -->
    <div id="page-container" class="fade page-sidebar-fixed page-header-fixed">
        @include ('topo')
        <!-- begin #header -->
        <!-- end #sidebar -->

        <!-- begin #content -->
        <div id="content" class="content">
            @if (\Session::has('success'))
            <div class="alert alert-success  fade in">
                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                <h4 style="box-sizing: border-box;">{!! \Session::get('success') !!}</h4>
            </div>
            @endif

            @if (\Session::has('error'))
            <div class="alert alert-danger  fade in">
                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                <h4 style="box-sizing: border-box;">{!! \Session::get('error') !!}</h4>
            </div>
            @endif
            <h1 class="page-header">Anexos de arquivos</h1>

            <div class="row">
                <div class="col-md-12">
                    <div class="panel panel-inverse">
                        <div class="panel-heading">
                            <div class="panel-heading-btn">
                                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-default" data-click="panel-expand"><i class="fa fa-expand"></i></a>
                                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-success" data-click="panel-reload"><i class="fa fa-repeat"></i></a>
                                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-warning" data-click="panel-collapse"><i class="fa fa-minus"></i></a>
                                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-danger" data-click="panel-remove"><i class="fa fa-times"></i></a>
                            </div>
                            <h4 class="panel-title">Anexar arquivos</h4>
                        </div>
                        <div class="panel-body">
                            <label><Strong>Máximo de 15 arquivos por envio - Tamanho máximo: 6Mb</Strong></label>

                            <form method="post" action="{{URL('anexo', $empreendimento->idempreendimento_cadastro)}}" enctype="multipart/form-data" class="dropzone" id="dropzone">
                                <!-- {{ csrf_field() }} -->


                                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                            </form>
                            <div style="margin-top: 25px;" align="center">
                                <button type="button" class="btn btn-info" id="submit-all">Enviar</button>
                            </div>
                        </div>

                        <!-- Script -->

                    </div>
                </div>
                <a href="javascript:;" class="btn btn-icon btn-circle btn-success btn-scroll-to-top fade" data-click="scroll-top"><i class="fa fa-angle-up"></i></a>
            </div>
            <div class="panel panel-inverse">
                <div class="panel-heading">
                    <div class="panel-heading-btn">
                        <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-default" data-click="panel-expand"><i class="fa fa-expand"></i></a>
                        <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-success" data-click="panel-reload"><i class="fa fa-repeat"></i></a>
                        <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-warning" data-click="panel-collapse"><i class="fa fa-minus"></i></a>
                        <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-danger" data-click="panel-remove"><i class="fa fa-times"></i></a>
                    </div>
                    <h4 class="panel-title">Arquivos anexados</h4>
                </div>
                <div class="panel-body">
                    <table id="data-table" class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>Código</th>

                                <th>Nome do arquivo</th>
                                <th>Ações</th>

                            </tr>
                        </thead>
                        <tbody>
                            @foreach($anexos as $anexo)
                            <tr class="odd gradeX">
                                <td>{{$anexo->idanexo_empreendimento}}</td>
                                <td>{{$anexo->nome_anexo_empreendimento}}</td>

                                <td>

                                    <a class="delete" id="{{$anexo->idanexo_empreendimento}}"><span class="label label-danger">Excluir Anexo</span></a>

                                </td>

                                @endforeach


                                <div class="modal fade" id="modal_excluir" role="dialog">
                                    <div class="modal-dialog modal-xs">

                                        <div class="modal-content">


                                            <style>
                                                .excluir {
                                                    background-color: #1a2229;
                                                    margin-top: -30px;
                                                }

                                                .excluir_mod {
                                                    color: white;
                                                    font-weight: bold;
                                                }

                                                .excluir_mod:hover {
                                                    color: black;
                                                    font-weight: bold;
                                                }

                                                .text-center {
                                                    background-color: #BD0900;
                                                    color: white;
                                                    padding: 15px;
                                                    box-sizing: border-box;
                                                    border-radius: 4px;
                                                }

                                                .pull-left {
                                                    font-size: 16px;
                                                }
                                            </style>

                                            <div class="modal-body">
                                                <legend class="text-center block2">Excluir anexo </legend>



                                                <div style="margin-bottom: 0px;" class="tab-content">

                                                    <div id="excluir" class="tab-pane fade in active">
                                                        <form method="POST" class="form-del" id="delete_form_modal">

                                                            <meta name="csrf-token" content="{{ csrf_token() }}">
                                                            <fieldset>
                                                                <legend class="pull-left width-full">Deseja realmente excluir o anexo selecionado? </legend>
                                                                <!-- <legend  class="pull-left width-full">Deseja realmente excluir o cadastro selecionado? </legend> -->
                                                            </fieldset>


                                                            <div class="text-right block3">
                                                                <button type="button" class="btn btn-danger" name="deleteModal" id="deleteModal">Sim, desejo excluir!</button>
                                                                <button type="button" class="btn btn-secondary" name="del" id="del" data-toggle="modal" data-target="#modal_excluir">Cancelar</button>
                                                                <!-- <input type="submit" name="deleteModal" id="deleteModal" value="Sim, desejo excluir!" class="btn btn-danger"> -->

                                                            </div>

                                                        </form>
                                                    </div>



                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>




                        </tbody>
                    </table>
                </div>
                <a href="javascript:;" class="btn btn-icon btn-circle btn-success btn-scroll-to-top fade" data-click="scroll-top"><i class="fa fa-angle-up"></i></a>
            </div>

            @include ('script')
            <script>
                var user_id;
                $(document).on('click', '.delete', function() {
                    user_id = $(this).attr('id');
                    $('#modal_excluir').modal('show');
                });
                $('#deleteModal').click(function() {
                    $.ajax({
                        url: "/anexos/delete/ " + user_id,
                        type: 'POST',

                        beforeSend: function() {
                            $('#deleteModal').text('Deletando...');
                        },
                        success: function(data) {
                            setTimeout(function() {
                                // $('#modal_excluir').modal('show');
                                // // $('#user_table').DataTable().ajax.reload();
                                // window.location.href = "anexo_empreendimento";
                                // success: function(data) { //   recebe todo o objeto do json, encapsula com nome do parametro da func
                                location.reload();
                                // swal("Sucesso!", "Anexo deletado com sucesso.", "success");

                            });
                            // swal("Sucesso","Cadastro deletado com successo!", "success");
                        }
                    });
                });
            </script>
            <script type="text/javascript">
                Dropzone.options.dropzone = {
                    method: 'POST',
                    autoProcessQueue: false,
                    // acceptedFiles: ".png,.jpg,.jpeg,.pdf,.js,.rar",
                    addRemoveLinks: true,
                    maxFiles: 15,
                    maxFilesize: 6,

                    init: function() {
                        var submitButton = document.querySelector("#submit-all");
                        myDropzone = this;

                        submitButton.addEventListener('click', function() {
                            myDropzone.processQueue();
                        });
                        this.on("complete", function() {
                            if (this.getQueuedFiles().length == 0 && this.getUploadingFiles().length == 0) {
                                var _this = this;
                                _this.removeAllFiles();
                            }

                        });

                    },
                    success: function(data) {

                        location.reload();
                        // swal("Sucesso!", "Anexo inserido com sucesso.", "success");
                    }
                };
            </script>
            <script>
                function readURL(input) {
                    if (input.files && input.files[0]) {
                        var reader = new FileReader();

                        reader.onload = function(e) {
                            $('#visualizar').attr('src', e.target.result);
                        }

                        reader.readAsDataURL(input.files[0]);
                    }
                }

                $("#selecao-arquivo").change(function() {
                    readURL(this);
                });
                $(document).ready(function() {
                    App.init();
                    TableManageButtons.init();
                    FormPlugins.init();
                });
            </script>
            <script>
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
            </script>
            <!-- @endforeach -->
</body>

</html>