<!DOCTYPE html>
<html>

<head>
    @include ('head')
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <style>
        @media (max-width: 600px) {
            .btn-cad {

                margin-left: -188px;

            }

        }
    </style>

</head>

<body>

    <!-- <form class="form-vertical form-bordered" name="myForm" method="POST"> -->
    <!-- begin #page-loader -->
    <div id="page-loader" class="fade in"><span class="spinner"></span></div>
    <!-- end #page-loader -->

    <!-- begin #page-container -->
    <div id="page-container" class="fade page-sidebar-fixed page-header-fixed">
        @include ('topo')
        <!-- begin #header -->
        <!-- end #sidebar -->

        <!-- begin #content -->
        <div id="content" class="content">
            @if (\Session::has('success'))
            <div class="alert alert-success  fade in">
                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                <h4 style="box-sizing: border-box;">{!! \Session::get('success') !!}</h4>
            </div>
            @endif

            @if (\Session::has('error'))
            <div class="alert alert-danger  fade in">
                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                <h4 style="box-sizing: border-box;">{!! \Session::get('error') !!}</h4>
            </div>
            @endif

            <ol class="breadcrumb pull-right">
                <li><a href="/cadastrar_conta"><span class="btn btn-success" style="font-size:100% !important;">NOVA CONTA</span></a></li>
            </ol>
            <h1 class="page-header">Conta Corrente</h1>

            <div class="row">
                <div class="col-md-12">
                    <div class="panel panel-inverse">
                        <div class="panel-heading">
                            <div class="panel-heading-btn">
                                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-default" data-click="panel-expand"><i class="fa fa-expand"></i></a>
                                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-success" data-click="panel-reload"><i class="fa fa-repeat"></i></a>
                                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-warning" data-click="panel-collapse"><i class="fa fa-minus"></i></a>
                                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-danger" data-click="panel-remove"><i class="fa fa-times"></i></a>
                            </div>
                            <h4 class="panel-title">Contas Cadastradasd</h4>
                        </div>

                        <div class="panel-body">
                            <table id="data-table" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>Banco</th>
                                        <th>Descrição Conta</th>
                                        <th>Agência&nbsp;-&nbsp;Dígito</th>
                                        <th>Nº Conta&nbsp;-&nbsp;Dígito</th>
                                        <th>Carteira</th>
                                        <th></th>

                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($listaContas as $listar)
                                    <tr class="odd gradeX">
                                        <td>{{$listar->banco}} - {{$listar->nome_banco}}</td>
                                        <td>{{$listar->descricao_conta}}</td>
                                        <td>{{$listar->agencia}} - {{$listar->dig_agencia}}</td>
                                        <td>{{$listar->conta}} - {{$listar->dig_conta}}</td>
                                        <td>{{$listar->carteira}}</td>
                                        <td>
                                            <a href="{!! url('/editar_conta', $listar->idcontacorrente) !!}"> <span class="label label-info">Visualizar/Editar</span></a>

                                            <a class="delete" id="{{$listar->idcontacorrente}}"><span class="label label-danger">Excluir Conta</span></a>

                                        </td>
                                    </tr>
                                    @endforeach


                                    <div class="modal fade" id="modal_excluir" role="dialog">
                                        <div class="modal-dialog modal-xs">

                                            <div class="modal-content">


                                                <style>
                                                    .excluir {
                                                        background-color: #1a2229;
                                                        margin-top: -30px;
                                                    }

                                                    .excluir_mod {
                                                        color: white;
                                                        font-weight: bold;
                                                    }

                                                    .excluir_mod:hover {
                                                        color: black;
                                                        font-weight: bold;
                                                    }

                                                    .text-center {
                                                        background-color: #BD0900;
                                                        color: white;
                                                        padding: 15px;
                                                        box-sizing: border-box;
                                                        border-radius: 4px;
                                                    }

                                                    .pull-left {
                                                        font-size: 16px;
                                                    }
                                                </style>

                                                <div class="modal-body">
                                                    <legend class="text-center block2">Excluir empreendimento </legend>



                                                    <div style="margin-bottom: 0px;" class="tab-content">

                                                        <div id="excluir" class="tab-pane fade in active">
                                                            <form method="POST" class="form-del" id="delete_form_modal">

                                                                <meta name="csrf-token" content="{{ csrf_token() }}">
                                                                <fieldset>
                                                                    <legend class="pull-left width-full">Deseja realmente excluir o empreendimento selecionado? </legend>
                                                                    <!-- <legend  class="pull-left width-full">Deseja realmente excluir o cadastro selecionado? </legend> -->
                                                                </fieldset>


                                                                <div class="text-right block3">
                                                                    <button type="button" class="btn btn-danger" name="deleteModal" id="deleteModal">Sim, desejo excluir!</button>
                                                                    <button type="button" class="btn btn-secondary" name="del" id="del" data-toggle="modal" data-target="#modal_excluir">Cancelar</button>
                                                                    <!-- <input type="submit" name="deleteModal" id="deleteModal" value="Sim, desejo excluir!" class="btn btn-danger"> -->

                                                                </div>

                                                            </form>
                                                        </div>



                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>




                                </tbody>

                            </table>
                        </div>
                    </div>

                </div>

                <!-- end col-10 -->
            </div>
            <!-- end row -->
        </div>
        <!-- end #content -->

        <!-- begin scroll to top btn -->
        <a href="javascript:;" class="btn btn-icon btn-circle btn-success btn-scroll-to-top fade" data-click="scroll-top"><i class="fa fa-angle-up"></i></a>
        <!-- end scroll to top btn -->
    </div>

    @include ('script')


    <script>
        $(document).ready(function() {
            App.init();
            TableManageButtons.init();
            FormPlugins.init();
        });
    </script>
    <script>
        var user_id;
        $(document).on('click', '.delete', function() {
            user_id = $(this).attr('id');
            $('#modal_excluir').modal('show');
        });
        $('#deleteModal').click(function() {
            $.ajax({
                url: "/contacorrente/delete/ " + user_id,
                type: 'POST',

                beforeSend: function() {
                    $('#deleteModal').text('Deletando...');
                },
                success: function(data) {
                    setTimeout(function() {
                        $('#modal_excluir').modal('show');
                        // $('#user_table').DataTable().ajax.reload();
                        window.location.href = "conta_corrente";

                    });
                    // swal("Sucesso","Cadastro deletado com successo!", "success");
                }
            });
        });



        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
    </script>

</body>

</html>