<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cliente', function (Blueprint $table) {
            $table->id();
            $table->string('nome_cli');
            $table->string('email_cli')->unique();
            $table->timestamp('email_cli_verified_at')->nullable();
            $table->string('senha');
            $table->rememberToken();
            $table->timestamps();






            $table->string('cpf_cli') ?: '0';
            $table->string('rg_cli') ?: '0';
            $table->string('estadocivil_cli') ?: '0';
            $table->string('nacionalidade_cli') ?: '0';
            $table->string('profissao_cli') ?: '0';
            $table->string('nascimento_cli') ?: '0';
            $table->string('obs_cli') ?: '0';
            $table->string('estado_cli') ?: '0';
            $table->id('idgrupo') ?: '0';
            $table->id('imob_id') ?: '0';
            $table->string('creci') ?: '0';
            $table->string('insc_municipal') ?: '0';
            $table->id();
            $table->date('data_cadastro') ?: '0';
            $table->string('alterado_por') ?: '0';
            $table->string('data_alterado') ?: '0';
            $table->string('pessoa') ?: '0';
            $table->string('idgrupo_cliente') ?: '0';
            $table->string('cargo') ?: '0';
            $table->string('salario_base') ?: '0';
            $table->string('data_contratacao') ?: '0';
            $table->string('data_demissao') ?: '0';
            $table->string('foto_cli') ?: '0';
            $table->string('cpf_rfb') ?: '0';
            $table->string('renda_total') ?: '0';
            $table->string('orgao_expedidor') ?: '0';
            $table->string('idempreendimento_cadastro') ?: '0';
            $table->id('imob_id') ?: '0';
            $table->id('conta_id') ?: '0';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cliente');
    }
}
