<?php

namespace App\Http\Controllers;

use App\TipoEmpreeendimentoModel;
use App\EmpreendimentoCadModel;
use App\ProprietariosModel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use PhpParser\Node\Stmt\Foreach_;
use Illuminate\Support\Facades\Redirect;

class EmpreendimentoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct(EmpreendimentoCadModel $empreendimentoCadModel)
    {
        $this->middleware('auth');
        $this->empreendimentoCadModel = $empreendimentoCadModel;
    }
    ///////////////////////////////////////////////////View//////////////////////////////////////////////////////////
    public function index(EmpreendimentoCadModel $empreendimentoCadModel)
    {
        $user_id = Auth::user()->id;

        $empreendimentos = DB::select("SELECT * FROM empreendimento_cadastro where conta_id = $user_id");
        $propi = DB::select("SELECT * FROM cliente
        INNER JOIN cliente_tipo ON cliente.idcliente = cliente_tipo.idcliente 
        INNER JOIN tipo_cliente ON cliente_tipo.idtipo = tipo_cliente.idtipo 
        where cliente_tipo.idtipo = 12 AND conta_id = $user_id  order by nome_cli Asc");
        $listar = DB::select("SELECT * FROM cliente 
        
        INNER JOIN empreendimento_cadastro on cliente.idcliente = empreendimento_cadastro.cliente_id
        WHERE  cliente.conta_id =  $user_id", [1]);
        $teste = DB::select("SELECT * FROM cliente where conta_id = $user_id");


        return view('empreendimentos.empreendimentos', compact('empreendimentos', 'propi', 'listar', 'teste'));
    }
    ///////////////////////////////////////////////////View cadastro//////////////////////////////////////////////////////////
    public function CadastroEmpreendimento(Request $request)
    {
        $user_id = Auth::user()->id;

        $propi = DB::select("SELECT * FROM cliente
        INNER JOIN cliente_tipo ON cliente.idcliente = cliente_tipo.idcliente 
        INNER JOIN tipo_cliente ON cliente_tipo.idtipo = tipo_cliente.idtipo 
        where cliente_tipo.idtipo = 12 AND conta_id = $user_id  order by nome_cli Asc");
        return view('empreendimentos.cadastro_empreendimento', compact('propi'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    ////////////////////////////////////////////////////Editar//////////////////////////////////////////////////////////
    public function edit(
        Request $request,
        $id,
        EmpreendimentoCadModel $empreendimentoCadModel,
        ProprietariosModel $proprietariosModel
    ) {
        $empreendimentos = DB::select("SELECT * FROM empreendimento_cadastro WHERE idempreendimento_cadastro = $id ", [1]);

        // dd("SELECT * FROM empreendimento_cadastro WHERE idempreendimento_cadastro = $id ");
        $proprietarios = DB::select("SELECT * FROM proprietarios WHERE empreendimento_id = $id ", [1]);
        $user_id = Auth::user()->id;
        $propi = DB::select("SELECT * FROM cliente
        INNER JOIN cliente_tipo ON cliente.idcliente = cliente_tipo.idcliente 
        INNER JOIN tipo_cliente ON cliente_tipo.idtipo = tipo_cliente.idtipo 
        where cliente_tipo.idtipo = 12 AND conta_id = $user_id  order by nome_cli Asc");
        $listar = DB::select("SELECT * FROM cliente INNER JOIN empreendimento_cadastro on cliente.idcliente = empreendimento_cadastro.cliente_id WHERE empreendimento_cadastro.idempreendimento_cadastro = $id ");
        return view('empreendimentos.alterar_empreendimento', ['empreendimentos' => $empreendimentos], compact('empreendimentos', 'propi', 'proprietarios', 'listar'));
    }
    ///////////////////////////////////////////////////Delete//////////////////////////////////////////////////////////
    public function destroy(Request $request, $id)
    {

        $delEmpre = DB::delete("DELETE FROM empreendimento_cadastro where idempreendimento_cadastro =  $id");
        $delEmpre = DB::delete("DELETE FROM proprietarios where empreendimento_id =  $id");
    }
    ///////////////////////////////////////////////////Atualizar//////////////////////////////////////////////////////////
    public function update(Request $request, $id)
    {
        $descricao = $request->get('descricao');
        $cliente_id = $request->get('cliente_id');
        $tipo_empreendimentos = $request->get('tipo_empreendimento');
        $participacao = $request->get('participacao');
        $matricula_empreendimento  = $request->get('matricula_empreendimento');
        $cadastrado_por = $request->get('cadastrado_por_emp');

        $updateEmp = DB::update("UPDATE empreendimento_cadastro SET cliente_id = '$cliente_id', descricao_empreendimento = '$descricao',tipo_empreendimento = '$tipo_empreendimentos', matricula_empreendimento = '$matricula_empreendimento' WHERE idempreendimento_cadastro = $id");
        $updateProp = DB::update("UPDATE proprietarios SET percentual = '$participacao',proprietario_id = '$cliente_id' WHERE empreendimento_id = $id ");
        // dd("UPDATE proprietarios SET percentual = '$participacao',proprietario_id = '$cliente_id' WHERE empreendimento_id = $id ");
        // dd("UPDATE empreendimento_cadastro SET cliente_id = '$cliente_id', descricao_empreendimento = '$descricao',tipo_empreendimento = '$tipo_empreendimentos', matricula_empreendimento = '$matricula_empreendimento' WHERE idempreendimento_cadastro = $id");
        if ($updateEmp || $updateProp) {
            return redirect('empreendimentos')->with('success', 'Empreendimento alterado com successo!');
        } else {

            return redirect()->back()->with('error', 'Ocorreu um erro ao alterar o empreendimento, revise os dados e tente novamente!');
        }
    }
    ///////////////////////////////////////////////////View Mapa//////////////////////////////////////////////////////////
    public function mapa(
        Request $request,
        $id,
        EmpreendimentoCadModel $empreendimentoCadModel,
        ProprietariosModel $proprietariosModel
    ) {
        $empreendimentos = DB::select("SELECT * FROM empreendimento_cadastro WHERE idempreendimento_cadastro = $id ", [1]);
        $proprietarios = DB::select("SELECT * FROM proprietarios WHERE empreendimento_id = $id ", [1]);
        return view('empreendimentos.mapa_empreendimento', ['empreendimentos' => $empreendimentos], compact('empreendimentos', 'proprietarios',));
    }
    ///////////////////////////////////////////////////Cadastrar Mapa//////////////////////////////////////////////////////////
    public function cadastrarMapa(Request $request, $id)
    {


        // if ($request->hasFile('perfil_foto') && $request->file('perfil_foto')->isValid()) {


        $path_foto = $request->file('file');
        $name = uniqid(date('HisYmd'));
        $extension = $request->file->extension();
        $path_foto = "{$name}.{$extension}";
        $upload = $request->file->storeAs('mapa', $path_foto);


        // }

        $gravaMapa = DB::update("UPDATE empreendimento_cadastro  SET img_mapa ='$path_foto' WHERE idempreendimento_cadastro = $id");


        if ($gravaMapa) {
            return redirect()->back()->with('success', 'Mapa inserido com successo!');
        } else {

            return redirect()->back()->with('error', 'Ocorreu um erro ao inserir o mapa do empreendimento, verifique o arquivo e tente novamente.!');
        }
    }

    ///////////////////////////////////////////////////View Anexo//////////////////////////////////////////////////////////
    public function anexo(
        Request $request,
        $id,
        EmpreendimentoCadModel $empreendimentoCadModel,
        ProprietariosModel $proprietariosModel
    ) {
        $empreendimentos = DB::select("SELECT * FROM empreendimento_cadastro WHERE idempreendimento_cadastro = $id ", [1]);
        $proprietarios = DB::select("SELECT * FROM proprietarios WHERE empreendimento_id = $id ", [1]);
        $anexos = DB::select("SELECT * FROM empreendimento_anexo WHERE empreendimentocadastro_id = $id ", [1]);
        return view('empreendimentos.anexo_empreendimento', ['empreendimentos' => $empreendimentos], compact('empreendimentos', 'anexos', 'proprietarios',));
    }

    ///////////////////////////////////////////////////Cadastrar Anexo//////////////////////////////////////////////////////////
    public function cadastrarAnexo(Request $request, $id)
    {
        $path_anexo = $request->file('file');
        $name = date('ymd') . '_' . $path_anexo->getClientOriginalName();
        // $extension = $request->file->getClientOriginalExtension();
        $path_anexo = "{$name}";
        $upload = $request->file->storeAs('anexos/' . $id, $path_anexo);
        // dd($upload);


        $gravaAnexo = DB::insert("INSERT INTO empreendimento_anexo (empreendimentocadastro_id,nome_anexo_empreendimento,url_anexo)values($id,'$path_anexo','$upload' )");
        return response()->json(['success' => 'Cadastrado com sucessos']);
    }

    ///////////////////////////////////////////////////Deletar Anexo//////////////////////////////////////////////////////////
    public function deleteAnexo(Request $request, $id)
    {
        $delAnexo = DB::delete("DELETE FROM empreendimento_anexo where idanexo_empreendimento =  $id");
        return response()->json(['success' => $delAnexo]);

        if ($delAnexo) {
            return redirect('anexo_empreendimento')->with('success', 'Empreendimento deletado com successo!');
        } else {

            return redirect()->back()->with('error', 'Ocorreu um erro ao deletar o anexo, tente novamente mais tarde!');
        }
    }
    ///////////////////////////////////////////////////View Logomarca//////////////////////////////////////////////////////////
    public function logomarca(
        Request $request,
        $id,
        EmpreendimentoCadModel $empreendimentoCadModel,
        ProprietariosModel $proprietariosModel
    ) {
        $empreendimentos = DB::select("SELECT * FROM empreendimento_cadastro WHERE idempreendimento_cadastro = $id ", [1]);
        $proprietarios = DB::select("SELECT * FROM proprietarios WHERE empreendimento_id = $id ", [1]);
        $fotos = DB::select("SELECT * FROM empreendimento_foto where empreendimento_idempreendimento = $id", [1]);
        return view('empreendimentos.fotos_empreendimento', ['empreendimentos' => $empreendimentos], compact('empreendimentos', 'fotos', 'proprietarios',));
    }

    ///////////////////////////////////////////////////Cadastrar Foto//////////////////////////////////////////////////////////
    public function cadastrarFotos(Request $request, $id)
    {

        $path_foto_emp = $request->file('file');
        $name = date('ymd') . '_' . $path_foto_emp->getClientOriginalName();
        $nomeOri = $path_foto_emp->getClientOriginalName();
        // $extension = $request->file->getClientOriginalExtension();
        $path_foto_emp = "{$name}";
        $upload = $request->file->storeAs('fotos_empreendimento/' . $id, $path_foto_emp);
        // dd("INSERT INTO fotos emprendimento (empreendimento_idempreendimento, nome_foto,nome_original_foto, url_img)values($id,'$path_foto_emp','$nomeOri', '$upload' )");


        $gravaAnexo = DB::insert("INSERT INTO empreendimento_foto (empreendimento_idempreendimento, nome_foto,nome_original_foto, url_img)values($id,'$path_foto_emp','$nomeOri', '$upload' )");
        return response()->json(['success' => 'Cadastrado com sucessos']);
    }
    ///////////////////////////////////////////////////Deletar Foto//////////////////////////////////////////////////////////
    public function deleteFotos(Request $request, $id)
    {
        $delFotoEmp = DB::delete("DELETE FROM empreendimento_foto where idfotos_empreendimento =  $id");
        return response()->json(['success' => $delFotoEmp]);

        if ($delFotoEmp) {
            return redirect('fotos_empreendimento')->with('success', 'Imagem deletada com sucesso com successo!');
        } else {

            return redirect()->back()->with('error', 'Ocorreu um erro ao deletar a imagem, tente novamente mais tarde!');
        }
    }

    ///////////////////////////////////////////////////Atualizar Foto//////////////////////////////////////////////////////////
    public function editarFoto(
        Request $request,
        $id,
        EmpreendimentoCadModel $empreendimentoCadModel,
        ProprietariosModel $proprietariosModel
    ) {
        $empreendimentos = DB::select("SELECT * FROM empreendimento_cadastro WHERE idempreendimento_cadastro = $id ", [1]);
        $proprietarios = DB::select("SELECT * FROM proprietarios WHERE empreendimento_id = $id ", [1]);
        $fotos = DB::select("SELECT * FROM empreendimento_foto where empreendimento_idempreendimento = $id", [1]);
        return view('empreendimentos.alterar_foto', compact('empreendimentos', 'fotos', 'proprietarios',));
    }
    ///////////////////////////////////////////////////Marcar Principal//////////////////////////////////////////////////////////
    public function definePrincipal(Request $request, $id)
    {
        $id_foto = $request->get('id_foto');
        $url = $_POST['url_img'];
        // $id= $_POST['id_user'];
        // dd($id_foto);
        // $atualizaTb = DB::update("UPDATE empreendimento_foto SET nome_original_foto = '$url' WHERE idfotos_empreendimento = $id_foto ");
        $marcaPrincipal = DB::update("UPDATE empreendimento_cadastro SET img_lote ='$url'WHERE idempreendimento_cadastro = $id ");
        return response()->json(['success' => $marcaPrincipal]);


        if ($marcaPrincipal) {
            return redirect('logomarca')->with('success', 'A nova imagem principal foi definida!');
        } else {

            return redirect()->back()->with('error', 'Ocorreu um erro ao definir a imagem, tente novamente mais tarde!');
        }
    }
    ///////////////////////////////////////////////////View Gestao//////////////////////////////////////////////////////////
    public function CadastroGestao(Request $request)
    {
        $user_id = Auth::user()->id;
        $listaEmp = DB::select("SELECT * FROM empreendimento_cadastro WHERE conta_id = $user_id");
        $propi = DB::select("SELECT * FROM cliente
        INNER JOIN cliente_tipo ON cliente.idcliente = cliente_tipo.idcliente 
        INNER JOIN tipo_cliente ON cliente_tipo.idtipo = tipo_cliente.idtipo 
        where cliente_tipo.idtipo = 12 AND conta_id = $user_id  order by nome_cli Asc");
        $correcao = DB::select("SELECT * FROM indice_correcao");
        return view('empreendimentos.gestao_empreendimento', compact('propi', 'listaEmp', 'correcao'));
    }

    ///////////////////////////////////////////////////Listar Gestao//////////////////////////////////////////////////////////
    public function gestao(EmpreendimentoCadModel $empreendimentoCadModel)
    {
        $user_id = Auth::user()->id;

        $empreendimentos = DB::select("SELECT * FROM empreendimento_cadastro where conta_id = $user_id");
        $propi = DB::select("SELECT * FROM cliente
        INNER JOIN cliente_tipo ON cliente.idcliente = cliente_tipo.idcliente 
        INNER JOIN tipo_cliente ON cliente_tipo.idtipo = tipo_cliente.idtipo 
        where cliente_tipo.idtipo = 12 AND conta_id = $user_id  order by nome_cli Asc");
        $listar = DB::select("SELECT * FROM cliente 
        
        INNER JOIN empreendimento_cadastro on cliente.idcliente = empreendimento_cadastro.cliente_id
        WHERE  cliente.conta_id =  $user_id", [1]);
        $teste = DB::select("SELECT * FROM cliente where conta_id = $user_id");
        $listarGestao = DB::select("SELECT * FROM empreendimento_cadastro INNER JOIN empreendimento on empreendimento.empreendimento_cadastro_id = empreendimento_cadastro.idempreendimento_cadastro
        WHERE empreendimento_cadastro.conta_id = $user_id ");


        return view('empreendimentos.lista_gestao', compact('empreendimentos', 'propi', 'listar', 'teste', 'listarGestao'));
    }


    ///////////////////////////////////////////////////Novo Empreendimento//////////////////////////////////////////////////////////
    public function CadastrarEmpre(Request $request)
    {

        $user_id = Auth::user()->id;
        $descricao = $request->get('descricao');
        $cliente_id = $request->get('cliente_id');
        $tipo_empreendimentos = $request->get('tipo_empreendimento');
        $participacao = $request->get('participacao');
        $matricula_empreendimento  = $request->get('matricula_empreendimento');
        $cadastrado_por = $request->get('cadastrado_por_emp');

        // dd($cadastrado_por);
        $criaEmp = DB::insert("INSERT INTO empreendimento_cadastro (descricao_empreendimento, cliente_id,tipo_empreendimento, matricula_empreendimento, conta_id) 
        values ('$descricao', '$cliente_id','$tipo_empreendimentos','$matricula_empreendimento','$user_id')");


        $empreendimento_id = DB::getPdo()->lastInsertId();

        $criaProp = DB::insert("INSERT INTO proprietarios (empreendimento_id, proprietario_id, percentual)
         values ('$empreendimento_id', '$cliente_id','$participacao')");

        $username =  Auth::user($cadastrado_por)->name;
        $datalog = date('Y-m-d H:i:s');
        $usuario_id = $cadastrado_por;
        $descricao_log = "Usuário " . $username . " cadastrou o empreendimento: " . $descricao;

        $gravaLog = DB::insert("INSERT INTO log(data_log,usuario_id,descricao_log)
        values('$datalog',$usuario_id,'$descricao_log')");



        if ($criaEmp && $criaProp) {
            return redirect()->route('lista_gestao')->with('success', 'Empreendimento cadastrado com sucesso, cadastre e gerencie uma nova gestão!');
        } else {

            return redirect()->back()->with('error', 'Ocorreu um erro ao cadastrar o empreendimento, revise os dados e tente novamente!');
        }
    }

    ///////////////////////////////////////////////////Nova Gestao//////////////////////////////////////////////////////////
    public function CadastrarGestao(Request $request)
    {
        $user_id = Auth::user()->id;
        $nome_fantasia = $request->get('nome_fantasia');
        $empreendimento_id = $request->get('empreendimento_id');
        $comissao_entrada = $request->get('comissao_entrada');
        $comissao_restante = $request->get('comissao_restante');
        $pis = $request->get('pis');
        $cofins = $request->get('cofins');
        $multa_atraso = $request->get('multa_atraso');
        $juros_atraso = $request->get('juros_atraso');
        $indice_correcao = $request->get('indice_correcao');
        $dimob = $request->get('dimob');

        $cadGestao = DB::insert("INSERT INTO empreendimento (nome_fantasia, empreendimento_cadastro_id, comissao_entrada, comissao_restante, PIS, COFINS, multa_atraso, juros_atraso, dimob, indice_correcao,conta_id) 
        values ('$nome_fantasia','$empreendimento_id','$comissao_entrada', '$comissao_restante','$pis','$cofins','$multa_atraso','$juros_atraso','$dimob','$indice_correcao',$user_id)");

        if ($cadGestao) {

            return redirect('gestao_vendas')->with('success', 'Gestão cadastrada com sucesso!');
        } else {

            return redirect()->back()->with('error', 'Ocorreu um erro ao cadastrar gestão, verifique os dados e tente novamente!');
        }
    }
    ///////////////////////////////////////////////////View configuracoes//////////////////////////////////////////////////////////
    public function configuracoes(EmpreendimentoCadModel $empreendimentoCadModel, $id)
    {
        $user_id = Auth::user()->id;

        // $ss = DB::select("SELECT idempreendimento_cadastro FROM empreendimento_cadastro INNER JOIN empreendimento ON empreendimento.empreendimento_cadastro_id = empreendimento_cadastro.idempreendimento_cadastro
        // WHERE empreendimento_cadastro.conta_id = $user_id");

        // foreach ($ss as $list) {
        //     $idEmp = $list->idempreendimento_cadastro;
        // }

        $listarGestao = DB::select("SELECT * FROM empreendimento_cadastro INNER JOIN empreendimento on empreendimento.empreendimento_cadastro_id = empreendimento_cadastro.idempreendimento_cadastro
        WHERE empreendimento_cadastro.conta_id = $user_id ", [1]);
        $nomeGestao = DB::select("SELECT * FROM empreendimento WHERE idempreendimento = $id");

        foreach ($listarGestao as $list) {
            $idEmp = $list->idempreendimento_cadastro;
        }
        // dd($idEmp);
        $empreendimentos = DB::select("SELECT * FROM empreendimento_cadastro where conta_id = $user_id");
        $propi = DB::select("SELECT * FROM cliente
        INNER JOIN cliente_tipo ON cliente.idcliente = cliente_tipo.idcliente 
        INNER JOIN tipo_cliente ON cliente_tipo.idtipo = tipo_cliente.idtipo 
        where cliente_tipo.idtipo = 12 AND conta_id = $user_id  order by nome_cli Asc");
        $listar = DB::select("SELECT * FROM cliente 
        INNER JOIN empreendimento_cadastro on cliente.idcliente = empreendimento_cadastro.cliente_id
        WHERE  cliente.conta_id =  $user_id", [1]);
        // $idEmp = $id;

        $desconto_empreendimento = DB::select("SELECT * FROM desconto_empreendimento WHERE empreendimento_id = $idEmp ORDER BY desconto_empreendimento DESC");
        $parcelamento = DB::select("SELECT * FROM parcelamento_entrada WHERE empreendimento_id = $idEmp  ORDER BY parcelamento_entrada");
        $entradaMin = DB::select("SELECT percentual_entrada FROM entrada_minima WHERE empreendimento_id =  $idEmp");
        $pagamentoMax = DB::select("SELECT plano_pagamento FROM plano_pagamento WHERE empreendimento_id = $idEmp");
        $Correcao = DB::select("SELECT * FROM correcao where empreendimento_id = $idEmp");
        $EntradaInter = DB::select("SELECT * FROM empreendimento_inter WHERE empreendimento_id = $idEmp");
        $listarContas = DB::select("SELECT * FROM contacorrente WHERE conta_id =  $user_id");
        $Distrato = DB::select("SELECT * FROM custo_distrato WHERE empreendimento_id = $idEmp");
        $Serasa = DB::select("SELECT * FROM empreendimento_serasa WHERE idempreendimento_cadastro = $idEmp");
        $Scpc = DB::select("SELECT * FROM empreendimento_spc WHERE idempreendimento_cadastro = $idEmp");
        $PercentualComissao = DB::select("SELECT * FROM comissao_geral WHERE id_empreendimento = $idEmp");
        $listaEquipe = DB::select("SELECT * FROM cliente_tipo INNER JOIN cliente ON cliente_tipo.idcliente = cliente.idcliente where conta_id = $user_id AND idtipo = 11 order by nome_cli Asc");
        $equipeCadastrada = DB::select("SELECT DISTINCT * FROM empreendimento_imob INNER JOIN cliente ON empreendimento_imob.imobiliaria_id = cliente.idcliente where empreendimento_id = '$idEmp' GROUP by nome_cli order by nome_cli desc");
        $ListaRepasse = DB::select("SELECT * FROM repasse_equipe where id_empreendimento = '$idEmp' order by idrepasse desc");  ////////////////////////////////////////////////////ANTES LIMIT 1//////////////////////////////////////////////////////////


        // dd("SELECT * FROM desconto_empreendimento WHERE empreendimento_id = $id ORDER BY desconto_empreendimento DESC");

        return view('empreendimentos.configuracoes.configuracoes_emp', compact(
            'empreendimentos',
            'propi',
            'listar',
            'desconto_empreendimento',
            'idEmp',
            'parcelamento',
            'entradaMin',
            'pagamentoMax',
            'Correcao',
            'EntradaInter',
            'listarContas',
            'Distrato',
            'Serasa',
            'Scpc',
            'PercentualComissao',
            'listaEquipe',
            'equipeCadastrada',
            'ListaRepasse',
            'listarGestao',
            'nomeGestao'
        ));
    }
    ///////////////////////////////////////////////////Deletar Gestao//////////////////////////////////////////////////////////
    public function deleteGestao($id)
    {

        $deletarGestao = DB::delete("DELETE FROM empreendimento WHERE idempreendimento = $id ");

        return response()->json(['success' => ' Device has been deleted!']);
    }
    ///////////////////////////////////////////////////Cria desconto//////////////////////////////////////////////////////////
    public function descontos(Request $request, $id)
    {

        $desconto_empreendimento = $request->get('desconto_empreendimento');
        $num_max_parcelas = $request->get('num_max_parcelas');


        $cadastraDesc = DB::insert("INSERT INTO desconto_empreendimento (empreendimento_id, desconto_empreendimento,parcela_max)
         values($id,'$desconto_empreendimento','$num_max_parcelas')");


        if ($cadastraDesc) {
            return redirect()->back()->with('success', 'Desconto cadastrado com sucesso!');
        } else {

            return redirect()->back()->with('error', 'Erro ao realizar desconto, verifique os campos e tente novamente!');
        }
    }
    ///////////////////////////////////////////////////Cria Parcelamento//////////////////////////////////////////////////////////
    public function parcelamento(Request $request, $id)
    {

        $parcelamento_entrada = $request->get('parcelamento_entrada');


        $cadastrarParc = DB::insert("INSERT INTO parcelamento_entrada (empreendimento_id, parcelamento_entrada)
         values($id,'$parcelamento_entrada')");


        if ($cadastrarParc) {
            return redirect()->back()->with('success', 'Parcelamento cadastrado com sucesso!');
        } else {

            return redirect()->back()->with('error', 'Erro ao cadastrar parcelamento, verifique os campos e tente novamente!');
        }
    }
    ///////////////////////////////////////////////////Cria Minimo//////////////////////////////////////////////////////////
    public function minimo(Request $request, $id)
    {

        $percentual_entrada = $request->get('percentual_entrada');

        $buscaMinima = DB::select("SELECT * FROM entrada_minima WHERE empreendimento_id =  $id");

        if ($buscaMinima != false) {
            $updateMinima = DB::update("UPDATE entrada_minima SET percentual_entrada = '$percentual_entrada' WHERE empreendimento_id = $id");

            return redirect()->back()->with('success', 'Entrada minima atualizada com sucesso!');
        } else {

            $cadastraEnt = DB::insert("INSERT INTO entrada_minima (empreendimento_id, percentual_entrada)
        values($id,'$percentual_entrada')");

            return redirect()->back()->with('success', 'Parcelamento cadastrado com sucesso!');
        }
    }
    ///////////////////////////////////////////////////Cria Plano//////////////////////////////////////////////////////////
    public function plano(Request $request, $id)
    {

        $plano_pagamento = $request->get('plano_pagamento');

        $buscaPlano = DB::select("SELECT * FROM plano_pagamento WHERE empreendimento_id = $id ");
// dd($buscaPlano);
        if ($buscaPlano != false) {
            $updateConta = DB::update("UPDATE plano_pagamento SET plano_pagamento = '$plano_pagamento' WHERE empreendimento_id = $id");

            return redirect()->back()->with('success', 'Plano de pagamento atualizado com sucesso!');
        } else {
            $cadastraPlan = DB::insert("INSERT INTO plano_pagamento (empreendimento_id, plano_pagamento)
            values($id,'$plano_pagamento')");

            return redirect()->back()->with('success', 'Plano de pagamento cadastrado com sucesso!');
        }
    }
    ///////////////////////////////////////////////////Cria Correcao//////////////////////////////////////////////////////////
    public function correcao(Request $request, $id)
    {

        $taxa_entrada = $request->get('taxa_entrada') ?: 0;
        $taxa_financiamento = $request->get('taxa_financiamento') ?: 0;
        $taxa_financiamento_vdd = $request->get('taxa_financiamento_vdd') ?: 0;
        $percen_lote = $request->get('percen_lote') ?: 0;
        $taxa_inter = $request->get('taxa_inter') ?: 0;
        $travar_financiamento_vdd = $request->get('travar_financiamento_vdd') ?: 0;
        $correcao_finan_fixo = $request->get('correcao_finan_fixo') ?: 0;
        $status = $request->get('status') ?: 0;
        $trava_inter = $request->get('trava_inter') ?: 0;
        $parcela_unica = $request->get('parcela_unica') ?: 0;
        $price = $request->get('price') ?: 0;
        $sac = $request->get('sac') ?: 0;
        $semjuros = $request->get('semjuros') ?: 0;



        $buscaCorrecao = DB::select("SELECT * FROM correcao WHERE empreendimento_id = $id");

        if ($buscaCorrecao != false) {
            $updateCorrecao = DB::update("UPDATE correcao SET taxa_financiamento = '$taxa_financiamento', taxa_entrada = '$taxa_entrada', correcao_finan_fixo = '$correcao_finan_fixo' WHERE empreendimento_id = $id");
            $updateEmpreendimentoInter = DB::update("UPDATE empreendimento_inter SET  percen_lote = '$percen_lote',  taxa_inter = '$taxa_inter',  status_ativo = '$status',  status_parc_unica = '$parcela_unica',  trava_inter = '$trava_inter', price = '$price', sac = '$sac',
             semjuros = '$semjuros',  juros_financiamento = '$taxa_financiamento_vdd',  trava_financiamento = '$travar_financiamento_vdd' WHERE empreendimento_id = $id");
            return redirect()->back()->with('success', 'Correção de entrada atualizada com sucesso!');
        } else {
            $criaCorrecao = DB::insert("INSERT INTO correcao (empreendimento_id, taxa_financiamento, taxa_entrada,correcao_finan_fixo) 
            values('$id','$taxa_financiamento','$taxa_entrada','$correcao_finan_fixo')");

            $criaInter = DB::insert("INSERT INTO empreendimento_inter (empreendimento_id, percen_lote, taxa_inter, status_ativo, status_parc_unica, trava_inter,price,sac,semjuros, juros_financiamento, trava_financiamento) 
            values($id, '$percen_lote','$taxa_inter', $status, $parcela_unica, $trava_inter, $price, $sac, $semjuros, '$taxa_financiamento_vdd', $travar_financiamento_vdd)");

            return redirect()->back()->with('success', 'Correção de entrada cadastrada com sucesso!');
        }
    }

    ///////////////////////////////////////////////////Cria Centro Custo//////////////////////////////////////////////////////////
    public function centroCusto(Request $request, $id)
    {

        $contacorrente = $request->get('contacorrente');
        $centrocusto_id                      = 1;

        $buscaConta = DB::select("SELECT * FROM empreendimento_centrocusto WHERE empreendimento_id = $id ");

        if ($buscaConta != false) {
            $updateConta = DB::update("UPDATE empreendimento_centrocusto SET centrocusto_id = '$centrocusto_id', contacorrente_id = '$contacorrente' WHERE empreendimento_id = $id");

            return redirect()->back()->with('success', 'Conta Corrente atualizada com sucesso!');
        } else {

            $cadastraCentro = DB::insert("INSERT INTO empreendimento_centrocusto (empreendimento_id, centrocusto_id, contacorrente_id)
            values($id,'$centrocusto_id','$contacorrente')");

            return redirect()->back()->with('success', 'Conta Corrente cadastrada com sucesso!');
        }
    }
    ///////////////////////////////////////////////////Cria Distrato//////////////////////////////////////////////////////////
    public function distrato(Request $request, $id)
    {
        $descricao_custo = $request->get('descricao_custo');
        $percentual_custo = $request->get('percentual_custo');
        $impacto_custo = $request->get('impacto_custo');

        // $buscaDistrato = DB::select("SELECT * FROM custo_distrato WHERE empreendimento_id = $id");

        // if ($buscaDistrato > 0) {
        //     $updateDistrato = DB::update("UPDATE custo_distrato SET descricao_custo = '$descricao_custo', percentual_custo = '$percentual_custo', impacto_custo = '$impacto_custo' WHERE empreendimento_id = $id");

        //     return redirect()->back()->with('success', 'Distrato atualizado com sucesso!');
        // } else {
        // }

        $cadastraDistrato = DB::insert("INSERT INTO custo_distrato (descricao_custo, empreendimento_id, percentual_custo, impacto_custo)
            values ('$descricao_custo', $id, '$percentual_custo', '$impacto_custo')");

        if ($cadastraDistrato) {
            return redirect()->back()->with('success', 'Distrato cadastrado com sucesso!');
        } else {

            return redirect()->back()->with('error', 'Ocorreu um erro ao cadastrar distrato, verifique o dados e tente novamente.');
        }
    }

    ///////////////////////////////////////////////////Cria Serasa//////////////////////////////////////////////////////////
    public function serasa(Request $request, $id)
    {

        $email = $request->get('email');
        $senha = $request->get('senha');
        $total_ocorrencias = $request->get('total_ocorrencias');
        $data_ocorrencia = $request->get('data_ocorrencia');
        $valor_total_ocorrencia = $request->get('valor_total_ocorrencia');
        $valor_riskSore = $request->get('valor_riskSore');


        if (isset($_POST["aprova_automatico"])) {
            $chec = 1;
        } else {
            $chec = 0;
        }

        if (isset($_POST["consulta_RiskSore"])) {
            $consulta = 1;
        } else {
            $consulta = 0;
        }

        if (isset($_POST["sem_consulta"])) {
            $nenhum = 1;
        } else {
            $nenhum = 0;
        }


        $buscaSerasa = DB::select("SELECT * FROM empreendimento_serasa WHERE idempreendimento_cadastro = $id ");

        if ($buscaSerasa != false) {
            $updateSerasa = DB::update("UPDATE empreendimento_serasa   SET idempreendimento_cadastro = '$id', total_ocorre = '$total_ocorrencias', data_ocorre = '$data_ocorrencia', 
            valor_Sore = '$valor_riskSore', valor_total_ocorre = '$valor_total_ocorrencia', chec = '$chec', email = '$email', senha = '$senha', consulta = '$consulta', nenhum = '$nenhum' WHERE idempreendimento_cadastro = $id");
            return redirect()->back()->with('success', 'Dados sobre o Serasa atualizados com sucesso!');
        } else {
            $cadastraSerasa = DB::insert("INSERT INTO empreendimento_serasa (idempreendimento_cadastro, total_ocorre, data_ocorre, valor_Sore, valor_total_ocorre, chec, email, senha, consulta, nenhum)
            values($id, '$total_ocorrencias', '$data_ocorrencia', '$valor_riskSore', '$valor_total_ocorrencia', '$chec', '$email', '$senha', '$consulta', '$nenhum')");


            return redirect()->back()->with('success', 'Dados sobre o Serasa cadastrados com sucesso!');
        }
    }
    ///////////////////////////////////////////////////Cria SCPC//////////////////////////////////////////////////////////
    public function scpc(Request $request, $id)
    {
        $primeira_parcela                   = $request->get('primeira_parcela');
        $tipo_credito                       = $request->get('tipo_credito');
        $token_acesso                       = $request->get('token');
        $codigo_associado                   = $request->get('codigo_associado');
        $senha_spc                          = $request->get('senha');
        $codigo_servico_associado           = $request->get('codigo_servico_associado');
        $entidade_associado                 = $request->get('entidade_associado');
        $telefone_associado                 = $request->get('telefone_associado');
        $ddd_associado                      = $request->get('ddd_associado');
        $modelo_score_associado             = $request->get('modelo_score_associado');
        $com_spc                            = $request->get('com_spc');
        $com_cheque                         = $request->get('com_cheque');
        $aprova_auto_spc                    = $request->get('aprova_auto_spc');
        $total_score_spc                    = $request->get('total_score_spc');
        $total_debitos_spc                  = $request->get('total_debitos_spc');
        $valor_maximo_spc                   = $request->get('valor_maximo_spc');
        $data_maxima_spc                    = $request->get('data_maxima_spc');


        $valor_maximo_spc = str_replace("R$", "", $valor_maximo_spc);
        $valor_maximo_spc = str_replace(".", "", $valor_maximo_spc);
        $valor_maximo_spc = str_replace(",", ".", $valor_maximo_spc);
        $valor_maximo_spc = substr($valor_maximo_spc, 2);

        isset($_POST['primeira_parcela']) ? $primeira_parcela = 1 : $primeira_parcela = 0;

        $buscaSCPC = DB::select("SELECT * FROM empreendimento_spc WHERE idempreendimento_cadastro = $id");

        if ($buscaSCPC != false) {
            $inserir = DB::update("UPDATE empreendimento_spc SET token_spc = '$token_acesso', senha_spc = '$senha_spc', codigo_servico_spc = '$codigo_servico_associado', tipo_credito_spc = '$tipo_credito', codigo_associado_spc = '$codigo_associado', telefone_spc = '$telefone_associado', ddd_spc = '$ddd_associado', entidade_spc = '$entidade_associado', modelo_score_spc = '$modelo_score_associado', consulta_cheque_spc = '$com_cheque', aprovar_automatico_spc = '$aprova_auto_spc', com_spc = '$com_spc', score_spc = '$total_score_spc', total_debitos_spc = '$total_debitos_spc', valor_acumulado_spc = '$valor_maximo_spc', data_primeiro_debito_spc = '$data_maxima_spc' WHERE idempreendimento_cadastro = $id");
            return redirect()->back()->with('success', 'Dados sobre o SCPC atualizados com sucesso!');
        } else {
            $inserir = DB::insert("INSERT INTO empreendimento_spc (token_spc, senha_spc, codigo_servico_spc, tipo_credito_spc, idempreendimento_cadastro, codigo_associado_spc, telefone_spc, ddd_spc, entidade_spc, modelo_score_spc, consulta_cheque_spc, aprovar_automatico_spc, com_spc, score_spc, total_debitos_spc, valor_acumulado_spc, data_primeiro_debito_spc)VALUES ('$token_acesso', '$senha_spc', '$codigo_servico_associado', '$tipo_credito', $id, '$codigo_associado', '$telefone_associado', '$ddd_associado', '$entidade_associado', '$modelo_score_associado', '$com_cheque', '$aprova_auto_spc', '$com_spc', '$total_score_spc', '$total_debitos_spc', '$valor_maximo_spc', '$data_maxima_spc')");
            return redirect()->back()->with('success', 'Dados sobre o SCPC cadastrados com sucesso!');
        }
    }
    ///////////////////////////////////////////////////Cria Percentual Comissao//////////////////////////////////////////////////////////
    public function percentualComissao(Request $request, $id)
    {

        $comissao_equipe                    = $request->get('comissao_equipe');

        $cadastraPercentual  = DB::insert("INSERT INTO comissao_geral (id_empreendimento, percentualgeral) values($id, '$comissao_equipe')");

        if ($cadastraPercentual) {
            return redirect()->back()->with('success', 'Dados de comissão geral cadastrados com sucesso!');
        } else {
            return redirect()->back()->with('error', 'Ocorreu um erro ao  cadastrar os dados de comissão geral, verifique os dados e tente novamente!');
        }
    }
    ///////////////////////////////////////////////////Cria Cadastro de equipe//////////////////////////////////////////////////////////
    public function cadastroEquipe(Request $request, $id)
    {

        $id_equipe = $request->get('equipe_v');


        $cadastraEquipe = DB::insert("INSERT INTO empreendimento_imob(imobiliaria_id,empreendimento_id)VALUES('$id_equipe','$id')");
        if ($cadastraEquipe) {
            return redirect()->back()->with('success', 'Equipe cadastrada com sucesso!');
        } else {
            return redirect()->back()->with('error', 'Ocorreu um erro ao  cadastrar equipe, verifique os dados e tente novamente!');
        }
    }
    ///////////////////////////////////////////////////Cria Repasse//////////////////////////////////////////////////////////

    public function repasseEquipe(Request $request, $id)
    {
        $repasse_equipe = $request->get('repasse_equipe');


        $cadastraRepasse = DB::insert("INSERT INTO repasse_equipe (id_empreendimento, percentual) values( $id, '$repasse_equipe')");
        if ($cadastraRepasse) {
            return redirect()->back()->with('success', 'Percentual de repasse cadastrado com sucesso!');
        } else {
            return redirect()->back()->with('error', 'Ocorreu um erro ao cadastrar o repasse, verifique os dados e tente novamente!');
        }
    }
    ///////////////////////////////////////////////////View Lote//////////////////////////////////////////////////////////
    public function indexLote($id)
    {
        return view('empreendimentos.configuracoes.imprimir_emp');
    }
    public function buscaEquipe($id)
    {

        $dados = "";
        $buscarEquipe = DB::select("SELECT * FROM cliente_tipo
        INNER JOIN tipo_cliente ON cliente_tipo.idtipo = tipo_cliente.idtipo
        where idcliente = '$id'");

        foreach ($buscarEquipe as $busca) {
            $descricao_tipo = $busca->descricao_tipo;
            $dados .= $descricao_tipo . " / ";
        }
        return $dados;
        echo json_encode($dados);
    }


    ///////////////////////////////////////////////////Cria Busca Equipe para Ajax//////////////////////////////////////////////////////////

    public function mostraDetalheEquipe($id)
    {


        function percentual_equipe($id)
        {


            $query_amigo = DB::select("SELECT percentual_corretores FROM comissao_equipe where idcliente = '$id' ORDER BY idcomissaoequipe DESC LIMIT 1");

            foreach ($query_amigo as $perc) {
                $percentual_corretores = $perc->percentual_equipe;
            }
            return $percentual_corretores;
        }

        function tipo_cadastro($cliente_id)
        {
            $dados = "";
            $query_amigo = DB::select("SELECT * FROM cliente_tipo
                    INNER JOIN tipo_cliente ON cliente_tipo.idtipo = tipo_cliente.idtipo
                    where idcliente = '$cliente_id'");
            foreach ($query_amigo as $tipo) {
                $descricao_tipo = $tipo->descricao_tipo;
                $dados .= $descricao_tipo . " / ";
            }

            return $dados;
        }


        $percentual = percentual_equipe($id);

        $percentual = explode("|",  $percentual);


        $query_amigo = DB::select("SELECT * FROM cliente
                 where imob_id = '$id' or idcliente = '$id' order by nome_cli Asc ");

        foreach ($query_amigo as $cli) {
            $idcliente = $cli->idcliente;
            $nome_cli =  $cli->nome_cli;

            $tipo_retorno = tipo_cadastro($idcliente);


            $dados[$idcliente] =  $nome_cli . " - $tipo_retorno";
        }


        foreach ($percentual as  $value) {
            $trata = explode("-", $value);

            if ($trata[1] == '' or $trata[1] == null) {

                $trata[1] = 0;
            }

            $percentual[$trata[0]] = $trata[1];
        }
        $array_dados = array('dados' => $dados, 'percentual' => $percentual, 'nome_equipe' => $nome_equipe);
        echo json_encode($array_dados);
    }

    ////////////////////////////////////////////// DELETES PARCELAMENTO /////////////////////////////////////////////
    public function deleteParcelamento($id)
    {
        $deletaParcelamento = DB::delete("DELETE FROM parcelamento_entrada WHERE idparcelamento_entrada = $id");
        if ($deletaParcelamento) {
            return redirect()->back()->with('success', 'Parcelamento deletado com sucesso!');
        } else {
            return redirect()->back()->with('error', 'Ocorreu um erro ao deletar o parcelamento, tente novamente mais tarde!');
        }
    }
    public function deleteDesconto($id)
    {
        $deletaDesconto = DB::delete("DELETE FROM desconto_empreendimento WHERE iddesconto = $id");
        if ($deletaDesconto) {
            return redirect()->back()->with('success', 'Desconto deletado com sucesso!');
        } else {
            return redirect()->back()->with('error', 'Ocorreu um erro ao deletar o desconto, tente novamente mais tarde!');
        }
    }
    public function deleteComissao($id)
    {
        $deletaComissao = DB::delete("DELETE FROM comissao_geral WHERE idcomissaogeral = $id");
        if ($deletaComissao) {
            return redirect()->back()->with('success', 'Comissão deletada com sucesso!');
        } else {
            return redirect()->back()->with('error', 'Ocorreu um erro ao deletar comissão, tente novamente mais tarde!');
        }
    }
    public function deleteEquipe($id)
    {
        $deletaEquipe = DB::delete("DELETE FROM empreendimento_imob WHERE idempreendimento_imob = $id");
        if ($deletaEquipe) {
            return redirect()->back()->with('success', 'Equipe deletada com sucesso!');
        } else {
            return redirect()->back()->with('error', 'Ocorreu um erro ao deletar equipe, tente novamente mais tarde!');
        }
    }
    public function deleteDistrato($id)
    {
        $deletaDistrato = DB::delete("DELETE FROM custo_distrato WHERE idcusto_distrato = $id");
        if ($deletaDistrato) {
            return redirect()->back()->with('success', 'Dados de distrato deletados com sucesso!');
        } else {
            return redirect()->back()->with('error', 'Ocorreu um erro ao deletar dados de distrato, tente novamente mais tarde!');
        }
    }
    public function deleteRepasse($id)
    {
        $deletaRepasse = DB::delete("DELETE FROM repasse_equipe WHERE idrepasse = $id");
        if ($deletaRepasse) {
            return redirect()->back()->with('success', 'Percentual de repasse deletado com sucesso!');
        } else {
            return redirect()->back()->with('error', 'Ocorreu um erro ao deletar percentual de repasse, tente novamente mais tarde!');
        }
    }

    /////////////SMS////////////////////////

    // Rotina de Leads Cadastrados (site)
    public function atualizaSms(Request $request, $id)
    {

        if ($request->has('salvar_primeiro')) {


            if ($request->has('option')) {
                // Aqui faço a segunda etapa.
                // Verifico se já existe a rotina no banco. 
                $query = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Leads Cadastrados' AND id_empreendimento = $id ");
                dd($query);
            }
        }

        // Rotina Leads do dia Corretores / Imobiliárias

        if ($request->has('salvar_segundo')) {



            if ($request->has('option')) {
                // Aqui faço a segunda etapa.
                // Verifico se já existe a rotina no banco. 
                $query = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Leads do dia Corretores' AND id_empreendimento = $id ");
                if (mysqli_num_rows($query)) {
                    while ($result = mysqli_fetch_assoc($query)) {
                        $texto_existe = $result['modelo_msg'];
                    }

                    $selecionado = $_POST['option'];
                    $qtd = count($selecionado);

                    // Aqui verifico se minhas três opções foram setadas.
                    if ($qtd == 3) {
                        foreach ($selecionado as $value) {

                            if (!empty($_POST['texto'])) {
                                $texto = addslashes($_POST['texto']);
                            } else {
                                $texto = addslashes($texto_existe);
                            }

                            if (isset($_POST['check'])) {
                                $check = 1;
                            } else {
                                $check = 0;
                            }

                            // Aqui faço update das três opções. 
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Leads do dia Corretores' AND grupo_acesso = $value AND id_empreendimento = $id");
                        }
                        // Aqui verifico se minhas duas opções foram setadas.
                    } elseif ($qtd == 2) {

                        // Aqui verifico qual não está setada.
                        if ($selecionado['0'] == 5 && $selecionado['1'] == 6) {
                            $desmarcado = 7;
                        } elseif ($selecionado['0'] == 6 && $selecionado['1'] == 5) {
                            $desmarcado = 7;
                        } elseif ($selecionado['0'] == 7 && $selecionado['1'] == 5) {
                            $desmarcado = 6;
                        } elseif ($selecionado['0'] == 5 && $selecionado['1'] == 7) {
                            $desmarcado = 6;
                        } elseif ($selecionado['0'] == 6 && $selecionado['1'] == 7) {
                            $desmarcado = 5;
                        } elseif ($selecionado['0'] == 7 && $selecionado['1'] == 6) {
                            $desmarcado = 5;
                        }

                        if (!empty($_POST['texto'])) {
                            $texto = $texto = addslashes($_POST['texto']);
                        } else {
                            $texto = addslashes($texto_existe);
                        }
                        // Aqui faço update da opção que não foi setada (desativo).
                        $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = 0 WHERE rotina = 'Leads do dia Corretores' AND grupo_acesso = $desmarcado AND id_empreendimento = $id");

                        foreach ($selecionado as $value) {

                            if (!empty($_POST['texto'])) {
                                $texto = $texto = addslashes($_POST['texto']);
                            } else {
                                $texto = addslashes($texto_existe);
                            }

                            if (isset($_POST['check'])) {
                                $check = 1;
                            } else {
                                $check = 0;
                            }
                            // Aqui faço update das duas opções que foram setadas.
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Leads do dia Corretores' AND grupo_acesso = $value AND id_empreendimento = $id");
                        }
                        // Aqui verifico se minha opçõe foi setada.
                    } else {

                        if (!empty($_POST['texto'])) {
                            $texto = $texto = addslashes($_POST['texto']);
                        } else {
                            $texto = addslashes($texto_existe);
                        }

                        if (isset($_POST['check'])) {
                            $check = 1;
                        } else {
                            $check = 0;
                        }

                        // Aqui vejo qual está selecionada.
                        if ($selecionado['0'] ==  5) {
                            $unico = $selecionado['0'];
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Leads do dia Corretores' AND grupo_acesso = $unico AND id_empreendimento = $id");
                        } else {
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = 0 WHERE rotina = 'Leads do dia Corretores' AND grupo_acesso = 5 AND id_empreendimento = $id");
                        }

                        if ($selecionado['0'] ==  6) {
                            $unico = $selecionado['0'];
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Leads do dia Corretores' AND grupo_acesso = $unico AND id_empreendimento = $id");
                        } else {
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = 0 WHERE rotina = 'Leads do dia Corretores' AND grupo_acesso = 6 AND id_empreendimento = $id");
                        }

                        if ($selecionado['0'] ==  7) {
                            $unico = $selecionado['0'];
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Leads do dia Corretores' AND grupo_acesso = $unico AND id_empreendimento = $id");
                        } else {
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = 0 WHERE rotina = 'Leads do dia Corretores' AND grupo_acesso = 7 AND id_empreendimento = $id");
                        }
                    }

                    header("Location: descontos.php?idempreendimento=" . $id);
                    die();
                } else {
                    // Aqui faço a primeira etapa.
                    $selecionado = $_POST['option'];

                    foreach ($selecionado as $value) {

                        if (isset($_POST['texto'])) {
                            $texto = $texto = addslashes($_POST['texto']);
                        }

                        if (isset($_POST['check'])) {
                            $check = 1;
                        } else {
                            $check = 0;
                        }
                        // // Aqui faço insert das três opções se foram setadas.
                        $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Leads do dia Corretores', '$texto', $value, $check)");
                    }

                    // Aqui adiciono o que não foi setado (se tiver);
                    $query1 = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Leads do dia Corretores' AND id_empreendimento = $id AND grupo_acesso = 5 ");
                    $query2 = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Leads do dia Corretores' AND id_empreendimento = $id AND grupo_acesso = 6 ");
                    $query3 = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Leads do dia Corretores' AND id_empreendimento = $id AND grupo_acesso = 7 ");

                    if (mysqli_num_rows($query1)) {
                    } else {
                        $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Leads do dia Corretores', '$texto', 5, 0)");
                    }

                    if (mysqli_num_rows($query2)) {
                    } else {
                        $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Leads do dia Corretores', '$texto', 6, 0)");
                    }

                    if (mysqli_num_rows($query3)) {
                    } else {
                        $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Leads do dia Corretores', '$texto', 7, 0)");
                    }

                    header("Location: descontos.php?idempreendimento=" . $id);
                    die();
                }
            }

            header("Location: descontos.php?idempreendimento=" . $id);
            die();
        }

        // Rotina Proposta de compra gerada

        if ($request->has('salvar_terceiro')) {




            if ($request->has('option')) {
                // Aqui faço a segunda etapa.
                // Verifico se já existe a rotina no banco. 
                $query = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Proposta de compra gerada' AND id_empreendimento = $id ");
                if (mysqli_num_rows($query)) {
                    while ($result = mysqli_fetch_assoc($query)) {
                        $texto_existe = $result['modelo_msg'];
                    }

                    $selecionado = $_POST['option'];
                    $qtd = count($selecionado);

                    // Aqui verifico se minhas três opções foram setadas.
                    if ($qtd == 3) {
                        foreach ($selecionado as $value) {

                            if (!empty($_POST['texto'])) {
                                $texto = addslashes($_POST['texto']);
                            } else {
                                $texto = addslashes($texto_existe);
                            }

                            if (isset($_POST['check'])) {
                                $check = 1;
                            } else {
                                $check = 0;
                            }

                            // Aqui faço update das três opções. 
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Proposta de compra gerada' AND grupo_acesso = $value AND id_empreendimento = $id");
                        }
                        // Aqui verifico se minhas duas opções foram setadas.
                    } elseif ($qtd == 2) {

                        // Aqui verifico qual não está setada.
                        if ($selecionado['0'] == 5 && $selecionado['1'] == 6) {
                            $desmarcado = 7;
                        } elseif ($selecionado['0'] == 6 && $selecionado['1'] == 5) {
                            $desmarcado = 7;
                        } elseif ($selecionado['0'] == 7 && $selecionado['1'] == 5) {
                            $desmarcado = 6;
                        } elseif ($selecionado['0'] == 5 && $selecionado['1'] == 7) {
                            $desmarcado = 6;
                        } elseif ($selecionado['0'] == 6 && $selecionado['1'] == 7) {
                            $desmarcado = 5;
                        } elseif ($selecionado['0'] == 7 && $selecionado['1'] == 6) {
                            $desmarcado = 5;
                        }

                        if (!empty($_POST['texto'])) {
                            $texto = $texto = addslashes($_POST['texto']);
                        } else {
                            $texto = addslashes($texto_existe);
                        }
                        // Aqui faço update da opção que não foi setada (desativo).
                        $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = 0 WHERE rotina = 'Proposta de compra gerada' AND grupo_acesso = $desmarcado AND id_empreendimento = $id");

                        foreach ($selecionado as $value) {

                            if (!empty($_POST['texto'])) {
                                $texto = $texto = addslashes($_POST['texto']);
                            } else {
                                $texto = addslashes($texto_existe);
                            }

                            if (isset($_POST['check'])) {
                                $check = 1;
                            } else {
                                $check = 0;
                            }
                            // Aqui faço update das duas opções que foram setadas.
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Proposta de compra gerada' AND grupo_acesso = $value AND id_empreendimento = $id");
                        }
                        // Aqui verifico se minha opçõe foi setada.
                    } else {

                        if (!empty($_POST['texto'])) {
                            $texto = $texto = addslashes($_POST['texto']);
                        } else {
                            $texto = addslashes($texto_existe);
                        }

                        if (isset($_POST['check'])) {
                            $check = 1;
                        } else {
                            $check = 0;
                        }

                        // Aqui vejo qual está selecionada.
                        if ($selecionado['0'] ==  5) {
                            $unico = $selecionado['0'];
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Proposta de compra gerada' AND grupo_acesso = $unico AND id_empreendimento = $id");
                        } else {
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = 0 WHERE rotina = 'Proposta de compra gerada' AND grupo_acesso = 5 AND id_empreendimento = $id");
                        }

                        if ($selecionado['0'] ==  6) {
                            $unico = $selecionado['0'];
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Proposta de compra gerada' AND grupo_acesso = $unico AND id_empreendimento = $id");
                        } else {
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = 0 WHERE rotina = 'Proposta de compra gerada' AND grupo_acesso = 6 AND id_empreendimento = $id");
                        }

                        if ($selecionado['0'] ==  7) {
                            $unico = $selecionado['0'];
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Proposta de compra gerada' AND grupo_acesso = $unico AND id_empreendimento = $id");
                        } else {
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = 0 WHERE rotina = 'Proposta de compra gerada' AND grupo_acesso = 7 AND id_empreendimento = $id");
                        }
                    }

                    header("Location: descontos.php?idempreendimento=" . $id);
                    die();
                } else {
                    // Aqui faço a primeira etapa.
                    $selecionado = $_POST['option'];

                    foreach ($selecionado as $value) {

                        if (isset($_POST['texto'])) {
                            $texto = $texto = addslashes($_POST['texto']);
                        }

                        if (isset($_POST['check'])) {
                            $check = 1;
                        } else {
                            $check = 0;
                        }
                        // // Aqui faço insert das três opções se foram setadas.
                        $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Proposta de compra gerada', '$texto', $value, $check)");
                    }

                    // Aqui adiciono o que não foi setado (se tiver);
                    $query1 = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Proposta de compra gerada' AND id_empreendimento = $id AND grupo_acesso = 5 ");
                    $query2 = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Proposta de compra gerada' AND id_empreendimento = $id AND grupo_acesso = 6 ");
                    $query3 = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Proposta de compra gerada' AND id_empreendimento = $id AND grupo_acesso = 7 ");

                    if (mysqli_num_rows($query1)) {
                    } else {
                        $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Proposta de compra gerada', '$texto', 5, 0)");
                    }

                    if (mysqli_num_rows($query2)) {
                    } else {
                        $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Proposta de compra gerada', '$texto', 6, 0)");
                    }

                    if (mysqli_num_rows($query3)) {
                    } else {
                        $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Proposta de compra gerada', '$texto', 7, 0)");
                    }

                    header("Location: descontos.php?idempreendimento=" . $id);
                    die();
                }
            }

            header("Location: descontos.php?idempreendimento=" . $id);
            die();
        }

        // Rotina Contrato aprovado / reprovado

        if ($request->has('salvar_quarto')) {



            if ($request->has('option')) {
                // Aqui faço a segunda etapa.
                // Verifico se já existe a rotina no banco. 
                $query = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Contrato aprovado reprovado' AND id_empreendimento = $id ");
                if (mysqli_num_rows($query)) {
                    while ($result = mysqli_fetch_assoc($query)) {
                        $texto_existe = $result['modelo_msg'];
                    }

                    $selecionado = $_POST['option'];
                    $qtd = count($selecionado);

                    // Aqui verifico se minhas três opções foram setadas.
                    if ($qtd == 3) {
                        foreach ($selecionado as $value) {

                            if (!empty($_POST['texto'])) {
                                $texto = addslashes($_POST['texto']);
                            } else {
                                $texto = addslashes($texto_existe);
                            }

                            if (isset($_POST['check'])) {
                                $check = 1;
                            } else {
                                $check = 0;
                            }

                            // Aqui faço update das três opções. 
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Contrato aprovado reprovado' AND grupo_acesso = $value AND id_empreendimento = $id");
                        }
                        // Aqui verifico se minhas duas opções foram setadas.
                    } elseif ($qtd == 2) {

                        // Aqui verifico qual não está setada.
                        if ($selecionado['0'] == 5 && $selecionado['1'] == 6) {
                            $desmarcado = 7;
                        } elseif ($selecionado['0'] == 6 && $selecionado['1'] == 5) {
                            $desmarcado = 7;
                        } elseif ($selecionado['0'] == 7 && $selecionado['1'] == 5) {
                            $desmarcado = 6;
                        } elseif ($selecionado['0'] == 5 && $selecionado['1'] == 7) {
                            $desmarcado = 6;
                        } elseif ($selecionado['0'] == 6 && $selecionado['1'] == 7) {
                            $desmarcado = 5;
                        } elseif ($selecionado['0'] == 7 && $selecionado['1'] == 6) {
                            $desmarcado = 5;
                        }

                        if (!empty($_POST['texto'])) {
                            $texto = $texto = addslashes($_POST['texto']);
                        } else {
                            $texto = addslashes($texto_existe);
                        }
                        // Aqui faço update da opção que não foi setada (desativo).
                        $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = 0 WHERE rotina = 'Contrato aprovado reprovado' AND grupo_acesso = $desmarcado AND id_empreendimento = $id");

                        foreach ($selecionado as $value) {

                            if (!empty($_POST['texto'])) {
                                $texto = $texto = addslashes($_POST['texto']);
                            } else {
                                $texto = addslashes($texto_existe);
                            }

                            if (isset($_POST['check'])) {
                                $check = 1;
                            } else {
                                $check = 0;
                            }
                            // Aqui faço update das duas opções que foram setadas.
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Contrato aprovado reprovado' AND grupo_acesso = $value AND id_empreendimento = $id");
                        }
                        // Aqui verifico se minha opçõe foi setada.
                    } else {

                        if (!empty($_POST['texto'])) {
                            $texto = $texto = addslashes($_POST['texto']);
                        } else {
                            $texto = addslashes($texto_existe);
                        }

                        if (isset($_POST['check'])) {
                            $check = 1;
                        } else {
                            $check = 0;
                        }

                        // Aqui vejo qual está selecionada.
                        if ($selecionado['0'] ==  5) {
                            $unico = $selecionado['0'];
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Contrato aprovado reprovado' AND grupo_acesso = $unico AND id_empreendimento = $id");
                        } else {
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = 0 WHERE rotina = 'Contrato aprovado reprovado' AND grupo_acesso = 5 AND id_empreendimento = $id");
                        }

                        if ($selecionado['0'] ==  6) {
                            $unico = $selecionado['0'];
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Contrato aprovado reprovado' AND grupo_acesso = $unico AND id_empreendimento = $id");
                        } else {
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = 0 WHERE rotina = 'Contrato aprovado reprovado' AND grupo_acesso = 6 AND id_empreendimento = $id");
                        }

                        if ($selecionado['0'] ==  7) {
                            $unico = $selecionado['0'];
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Contrato aprovado reprovado' AND grupo_acesso = $unico AND id_empreendimento = $id");
                        } else {
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = 0 WHERE rotina = 'Contrato aprovado reprovado' AND grupo_acesso = 7 AND id_empreendimento = $id");
                        }
                    }

                    header("Location: descontos.php?idempreendimento=" . $id);
                    die();
                } else {
                    // Aqui faço a primeira etapa.
                    $selecionado = $_POST['option'];

                    foreach ($selecionado as $value) {

                        if (isset($_POST['texto'])) {
                            $texto = $texto = addslashes($_POST['texto']);
                        }

                        if (isset($_POST['check'])) {
                            $check = 1;
                        } else {
                            $check = 0;
                        }
                        // // Aqui faço insert das três opções se foram setadas.
                        $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Contrato aprovado reprovado', '$texto', $value, $check)");
                    }

                    // Aqui adiciono o que não foi setado (se tiver);
                    $query1 = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Contrato aprovado reprovado' AND id_empreendimento = $id AND grupo_acesso = 5 ");
                    $query2 = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Contrato aprovado reprovado' AND id_empreendimento = $id AND grupo_acesso = 6 ");
                    $query3 = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Contrato aprovado reprovado' AND id_empreendimento = $id AND grupo_acesso = 7 ");

                    if (mysqli_num_rows($query1)) {
                    } else {
                        $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Contrato aprovado reprovado', '$texto', 5, 0)");
                    }

                    if (mysqli_num_rows($query2)) {
                    } else {
                        $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Contrato aprovado reprovado', '$texto', 6, 0)");
                    }

                    if (mysqli_num_rows($query3)) {
                    } else {
                        $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Contrato aprovado reprovado', '$texto', 7, 0)");
                    }

                    header("Location: descontos.php?idempreendimento=" . $id);
                    die();
                }
            }

            header("Location: descontos.php?idempreendimento=" . $id);
            die();
        }

        // Rotina Ocorrencias lançamento

        if ($request->has('salvar_quinta')) {




            if ($request->has('option')) {
                // Aqui faço a segunda etapa.
                // Verifico se já existe a rotina no banco. 
                $query = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Ocorrencias lancamento' AND id_empreendimento = $id ");
                if (mysqli_num_rows($query)) {
                    while ($result = mysqli_fetch_assoc($query)) {
                        $texto_existe = $result['modelo_msg'];
                    }

                    $selecionado = $_POST['option'];
                    $qtd = count($selecionado);

                    // Aqui verifico se minhas três opções foram setadas.
                    if ($qtd == 3) {
                        foreach ($selecionado as $value) {

                            if (!empty($_POST['texto'])) {
                                $texto = addslashes($_POST['texto']);
                            } else {
                                $texto = addslashes($texto_existe);
                            }

                            if (isset($_POST['check'])) {
                                $check = 1;
                            } else {
                                $check = 0;
                            }

                            // Aqui faço update das três opções. 
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Ocorrencias lancamento' AND grupo_acesso = $value AND id_empreendimento = $id");
                        }
                        // Aqui verifico se minhas duas opções foram setadas.
                    } elseif ($qtd == 2) {

                        // Aqui verifico qual não está setada.
                        if ($selecionado['0'] == 5 && $selecionado['1'] == 6) {
                            $desmarcado = 7;
                        } elseif ($selecionado['0'] == 6 && $selecionado['1'] == 5) {
                            $desmarcado = 7;
                        } elseif ($selecionado['0'] == 7 && $selecionado['1'] == 5) {
                            $desmarcado = 6;
                        } elseif ($selecionado['0'] == 5 && $selecionado['1'] == 7) {
                            $desmarcado = 6;
                        } elseif ($selecionado['0'] == 6 && $selecionado['1'] == 7) {
                            $desmarcado = 5;
                        } elseif ($selecionado['0'] == 7 && $selecionado['1'] == 6) {
                            $desmarcado = 5;
                        }

                        if (!empty($_POST['texto'])) {
                            $texto = $texto = addslashes($_POST['texto']);
                        } else {
                            $texto = addslashes($texto_existe);
                        }
                        // Aqui faço update da opção que não foi setada (desativo).
                        $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = 0 WHERE rotina = 'Ocorrencias lancamento' AND grupo_acesso = $desmarcado AND id_empreendimento = $id");

                        foreach ($selecionado as $value) {

                            if (!empty($_POST['texto'])) {
                                $texto = $texto = addslashes($_POST['texto']);
                            } else {
                                $texto = addslashes($texto_existe);
                            }

                            if (isset($_POST['check'])) {
                                $check = 1;
                            } else {
                                $check = 0;
                            }
                            // Aqui faço update das duas opções que foram setadas.
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Ocorrencias lancamento' AND grupo_acesso = $value AND id_empreendimento = $id");
                        }
                        // Aqui verifico se minha opçõe foi setada.
                    } else {

                        if (!empty($_POST['texto'])) {
                            $texto = $texto = addslashes($_POST['texto']);
                        } else {
                            $texto = addslashes($texto_existe);
                        }

                        if (isset($_POST['check'])) {
                            $check = 1;
                        } else {
                            $check = 0;
                        }

                        // Aqui vejo qual está selecionada.
                        if ($selecionado['0'] ==  5) {
                            $unico = $selecionado['0'];
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Ocorrencias lancamento' AND grupo_acesso = $unico AND id_empreendimento = $id");
                        } else {
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = 0 WHERE rotina = 'Ocorrencias lancamento' AND grupo_acesso = 5 AND id_empreendimento = $id");
                        }

                        if ($selecionado['0'] ==  6) {
                            $unico = $selecionado['0'];
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Ocorrencias lancamento' AND grupo_acesso = $unico AND id_empreendimento = $id");
                        } else {
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = 0 WHERE rotina = 'Ocorrencias lancamento' AND grupo_acesso = 6 AND id_empreendimento = $id");
                        }

                        if ($selecionado['0'] ==  7) {
                            $unico = $selecionado['0'];
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Ocorrencias lancamento' AND grupo_acesso = $unico AND id_empreendimento = $id");
                        } else {
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = 0 WHERE rotina = 'Ocorrencias lancamento' AND grupo_acesso = 7 AND id_empreendimento = $id");
                        }
                    }

                    header("Location: descontos.php?idempreendimento=" . $id);
                    die();
                } else {
                    // Aqui faço a primeira etapa.
                    $selecionado = $_POST['option'];

                    foreach ($selecionado as $value) {

                        if (isset($_POST['texto'])) {
                            $texto = $texto = addslashes($_POST['texto']);
                        }

                        if (isset($_POST['check'])) {
                            $check = 1;
                        } else {
                            $check = 0;
                        }
                        // // Aqui faço insert das três opções se foram setadas.
                        $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Ocorrencias lancamento', '$texto', $value, $check)");
                    }

                    // Aqui adiciono o que não foi setado (se tiver);
                    $query1 = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Ocorrencias lancamento' AND id_empreendimento = $id AND grupo_acesso = 5 ");
                    $query2 = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Ocorrencias lancamento' AND id_empreendimento = $id AND grupo_acesso = 6 ");
                    $query3 = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Ocorrencias lancamento' AND id_empreendimento = $id AND grupo_acesso = 7 ");

                    if (mysqli_num_rows($query1)) {
                    } else {
                        $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Ocorrencias lancamento', '$texto', 5, 0)");
                    }

                    if (mysqli_num_rows($query2)) {
                    } else {
                        $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Ocorrencias lancamento', '$texto', 6, 0)");
                    }

                    if (mysqli_num_rows($query3)) {
                    } else {
                        $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Ocorrencias lancamento', '$texto', 7, 0)");
                    }

                    header("Location: descontos.php?idempreendimento=" . $id);
                    die();
                }
            }

            header("Location: descontos.php?idempreendimento=" . $id);
            die();
        }

        // Rotina Ocorrencias tratativas
        if (isset($_POST['salvar_sexta'])) {



            if ($request->has('option')) {
                // Aqui faço a segunda etapa.
                // Verifico se já existe a rotina no banco. 
                $query = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Ocorrencias tratativas' AND id_empreendimento = $id ");
                if (mysqli_num_rows($query)) {
                    while ($result = mysqli_fetch_assoc($query)) {
                        $texto_existe = $result['modelo_msg'];
                    }

                    $selecionado = $_POST['option'];
                    $qtd = count($selecionado);

                    // Aqui verifico se minhas três opções foram setadas.
                    if ($qtd == 3) {
                        foreach ($selecionado as $value) {

                            if (!empty($_POST['texto'])) {
                                $texto = addslashes($_POST['texto']);
                            } else {
                                $texto = addslashes($texto_existe);
                            }

                            if (isset($_POST['check'])) {
                                $check = 1;
                            } else {
                                $check = 0;
                            }

                            // Aqui faço update das três opções. 
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Ocorrencias tratativas' AND grupo_acesso = $value AND id_empreendimento = $id");
                        }
                        // Aqui verifico se minhas duas opções foram setadas.
                    } elseif ($qtd == 2) {

                        // Aqui verifico qual não está setada.
                        if ($selecionado['0'] == 5 && $selecionado['1'] == 6) {
                            $desmarcado = 7;
                        } elseif ($selecionado['0'] == 6 && $selecionado['1'] == 5) {
                            $desmarcado = 7;
                        } elseif ($selecionado['0'] == 7 && $selecionado['1'] == 5) {
                            $desmarcado = 6;
                        } elseif ($selecionado['0'] == 5 && $selecionado['1'] == 7) {
                            $desmarcado = 6;
                        } elseif ($selecionado['0'] == 6 && $selecionado['1'] == 7) {
                            $desmarcado = 5;
                        } elseif ($selecionado['0'] == 7 && $selecionado['1'] == 6) {
                            $desmarcado = 5;
                        }

                        if (!empty($_POST['texto'])) {
                            $texto = $texto = addslashes($_POST['texto']);
                        } else {
                            $texto = addslashes($texto_existe);
                        }
                        // Aqui faço update da opção que não foi setada (desativo).
                        $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = 0 WHERE rotina = 'Ocorrencias tratativas' AND grupo_acesso = $desmarcado AND id_empreendimento = $id");

                        foreach ($selecionado as $value) {

                            if (!empty($_POST['texto'])) {
                                $texto = $texto = addslashes($_POST['texto']);
                            } else {
                                $texto = addslashes($texto_existe);
                            }

                            if (isset($_POST['check'])) {
                                $check = 1;
                            } else {
                                $check = 0;
                            }
                            // Aqui faço update das duas opções que foram setadas.
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Ocorrencias tratativas' AND grupo_acesso = $value AND id_empreendimento = $id");
                        }
                        // Aqui verifico se minha opçõe foi setada.
                    } else {

                        if (!empty($_POST['texto'])) {
                            $texto = $texto = addslashes($_POST['texto']);
                        } else {
                            $texto = addslashes($texto_existe);
                        }

                        if (isset($_POST['check'])) {
                            $check = 1;
                        } else {
                            $check = 0;
                        }

                        // Aqui vejo qual está selecionada.
                        if ($selecionado['0'] ==  5) {
                            $unico = $selecionado['0'];
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Ocorrencias tratativas' AND grupo_acesso = $unico AND id_empreendimento = $id");
                        } else {
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = 0 WHERE rotina = 'Ocorrencias tratativas' AND grupo_acesso = 5 AND id_empreendimento = $id");
                        }

                        if ($selecionado['0'] ==  6) {
                            $unico = $selecionado['0'];
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Ocorrencias tratativas' AND grupo_acesso = $unico AND id_empreendimento = $id");
                        } else {
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = 0 WHERE rotina = 'Ocorrencias tratativas' AND grupo_acesso = 6 AND id_empreendimento = $id");
                        }

                        if ($selecionado['0'] ==  7) {
                            $unico = $selecionado['0'];
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Ocorrencias tratativas' AND grupo_acesso = $unico AND id_empreendimento = $id");
                        } else {
                            $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = 0 WHERE rotina = 'Ocorrencias tratativas' AND grupo_acesso = 7 AND id_empreendimento = $id");
                        }
                    }

                    header("Location: descontos.php?idempreendimento=" . $id);
                    die();
                } else {
                    // Aqui faço a primeira etapa.
                    $selecionado = $_POST['option'];

                    foreach ($selecionado as $value) {

                        if (isset($_POST['texto'])) {
                            $texto = $texto = addslashes($_POST['texto']);
                        }

                        if (isset($_POST['check'])) {
                            $check = 1;
                        } else {
                            $check = 0;
                        }
                        // // Aqui faço insert das três opções se foram setadas.
                        $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Ocorrencias tratativas', '$texto', $value, $check)");
                    }

                    // Aqui adiciono o que não foi setado (se tiver);
                    $query1 = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Ocorrencias tratativas' AND id_empreendimento = $id AND grupo_acesso = 5 ");
                    $query2 = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Ocorrencias tratativas' AND id_empreendimento = $id AND grupo_acesso = 6 ");
                    $query3 = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Ocorrencias tratativas' AND id_empreendimento = $id AND grupo_acesso = 7 ");

                    if (mysqli_num_rows($query1)) {
                    } else {
                        $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Ocorrencias tratativas', '$texto', 5, 0)");
                    }

                    if (mysqli_num_rows($query2)) {
                    } else {
                        $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Ocorrencias tratativas', '$texto', 6, 0)");
                    }

                    if (mysqli_num_rows($query3)) {
                    } else {
                        $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Ocorrencias tratativas', '$texto', 7, 0)");
                    }

                    header("Location: descontos.php?idempreendimento=" . $id);
                    die();
                }
            }

            header("Location: descontos.php?idempreendimento=" . $id);
            die();
        }

        // Rotina Aviso de vencimento de parcelas

        if ($request->has('salvar_setima')) {



            // Verifico se já existe a rotina no banco. 
            $query = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Aviso de vencimento de parcelas' AND id_empreendimento = $id ");
            if (mysqli_num_rows($query)) {
                while ($result = mysqli_fetch_assoc($query)) {
                    $texto_existe = $result['modelo_msg'];
                }

                $selecionado = $_POST['option'];

                foreach ($selecionado as $value) {

                    if (!empty($_POST['texto'])) {
                        $texto = $texto = addslashes($_POST['texto']);
                    } else {
                        $texto = addslashes($texto_existe);
                    }

                    if (isset($_POST['check'])) {
                        $check = 1;
                    } else {
                        $check = 0;
                    }
                    // Aqui faço update das opções que foram setadas.
                    $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Aviso de vencimento de parcelas' AND grupo_acesso = $value AND id_empreendimento = $id");
                }
                header("Location: descontos.php?idempreendimento=" . $id);
                die();
            } else {
                // Aqui faço a primeira etapa.
                $selecionado = $_POST['option'];

                foreach ($selecionado as $value) {

                    if (isset($_POST['texto'])) {
                        $texto = $texto = addslashes($_POST['texto']);
                    }

                    if (isset($_POST['check'])) {
                        $check = 1;
                    } else {
                        $check = 0;
                    }
                    // Aqui faço insert das opções que foram setadas.
                    $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Aviso de vencimento de parcelas', '$texto', $value, $check)");
                }

                header("Location: descontos.php?idempreendimento=" . $id);
                die();
            }
        }

        // Rotina Aviso de parcelas em atraso

        if ($request->has('salvar_oitava')) {


            // Verifico se já existe a rotina no banco. 
            $query = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Aviso de parcelas em atraso' AND id_empreendimento = $id ");
            if (mysqli_num_rows($query)) {
                while ($result = mysqli_fetch_assoc($query)) {
                    $texto_existe = $result['modelo_msg'];
                }

                $selecionado = $_POST['option'];

                foreach ($selecionado as $value) {

                    if (!empty($_POST['texto'])) {
                        $texto = $texto = addslashes($_POST['texto']);
                    } else {
                        $texto = addslashes($texto_existe);
                    }

                    if (isset($_POST['check'])) {
                        $check = 1;
                    } else {
                        $check = 0;
                    }
                    // Aqui faço update das opções que foram setadas.
                    $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Aviso de parcelas em atraso' AND grupo_acesso = $value AND id_empreendimento = $id");
                }
                header("Location: descontos.php?idempreendimento=" . $id);
                die();
            } else {
                // Aqui faço a primeira etapa.
                $selecionado = $_POST['option'];

                foreach ($selecionado as $value) {

                    if (isset($_POST['texto'])) {
                        $texto = $texto = addslashes($_POST['texto']);
                    }

                    if (isset($_POST['check'])) {
                        $check = 1;
                    } else {
                        $check = 0;
                    }
                    // Aqui faço insert das opções que foram setadas.
                    $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Aviso de parcelas em atraso', '$texto', $value, $check)");
                }

                header("Location: descontos.php?idempreendimento=" . $id);
                die();
            }
        }

        // Rotina Lançamento de contas a pagar

        if ($request->has('salvar_nona')) {


            // Verifico se já existe a rotina no banco. 
            $query = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Lancamento de contas a pagar' AND id_empreendimento = $id ");
            if (mysqli_num_rows($query)) {
                while ($result = mysqli_fetch_assoc($query)) {
                    $texto_existe = $result['modelo_msg'];
                }

                $selecionado = $_POST['option'];

                foreach ($selecionado as $value) {

                    if (!empty($_POST['texto'])) {
                        $texto = $texto = addslashes($_POST['texto']);
                    } else {
                        $texto = addslashes($texto_existe);
                    }

                    if (isset($_POST['check'])) {
                        $check = 1;
                    } else {
                        $check = 0;
                    }
                    // Aqui faço update das opções que foram setadas.
                    $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Lancamento de contas a pagar' AND grupo_acesso = $value AND id_empreendimento = $id");
                }
                header("Location: descontos.php?idempreendimento=" . $id);
                die();
            } else {
                // Aqui faço a primeira etapa.
                $selecionado = $_POST['option'];

                foreach ($selecionado as $value) {

                    if (isset($_POST['texto'])) {
                        $texto = $texto = addslashes($_POST['texto']);
                    }

                    if (isset($_POST['check'])) {
                        $check = 1;
                    } else {
                        $check = 0;
                    }
                    // Aqui faço insert das opções que foram setadas.
                    $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Lancamento de contas a pagar', '$texto', $value, $check)");
                }

                header("Location: descontos.php?idempreendimento=" . $id);
                die();
            }
        }

        // Rotina Baixa de contas a pagar

        if ($request->has('salvar_decima')) {


            // Verifico se já existe a rotina no banco. 
            $query = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Baixa de contas a pagar' AND id_empreendimento = $id ");
            if (mysqli_num_rows($query)) {
                while ($result = mysqli_fetch_assoc($query)) {
                    $texto_existe = $result['modelo_msg'];
                }

                $selecionado = $_POST['option'];

                foreach ($selecionado as $value) {

                    if (!empty($_POST['texto'])) {
                        $texto = $texto = addslashes($_POST['texto']);
                    } else {
                        $texto = addslashes($texto_existe);
                    }

                    if (isset($_POST['check'])) {
                        $check = 1;
                    } else {
                        $check = 0;
                    }
                    // Aqui faço update das opções que foram setadas.
                    $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Baixa de contas a pagar' AND grupo_acesso = $value AND id_empreendimento = $id");
                }
                header("Location: descontos.php?idempreendimento=" . $id);
                die();
            } else {
                // Aqui faço a primeira etapa.
                $selecionado = $_POST['option'];

                foreach ($selecionado as $value) {

                    if (isset($_POST['texto'])) {
                        $texto = $texto = addslashes($_POST['texto']);
                    }

                    if (isset($_POST['check'])) {
                        $check = 1;
                    } else {
                        $check = 0;
                    }
                    // Aqui faço insert das opções que foram setadas.
                    $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Baixa de contas a pagar', '$texto', $value, $check)");
                }

                header("Location: descontos.php?idempreendimento=" . $id);
                die();
            }
        }

        // Rotina Baixa de contas a receber.

        if ($request->has('salvar_decima1')) {


            // Verifico se já existe a rotina no banco. 
            $query = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Baixa de parcelas' AND id_empreendimento = $id ");
            if (mysqli_num_rows($query)) {
                while ($result = mysqli_fetch_assoc($query)) {
                    $texto_existe = $result['modelo_msg'];
                }

                $selecionado = $_POST['option'];

                foreach ($selecionado as $value) {

                    if (!empty($_POST['texto'])) {
                        $texto = $texto = addslashes($_POST['texto']);
                    } else {
                        $texto = addslashes($texto_existe);
                    }

                    if (isset($_POST['check'])) {
                        $check = 1;
                    } else {
                        $check = 0;
                    }
                    // Aqui faço update das opções que foram setadas.
                    $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Baixa de parcelas' AND grupo_acesso = $value AND id_empreendimento = $id");
                }
                header("Location: descontos.php?idempreendimento=" . $id);
                die();
            } else {
                // Aqui faço a primeira etapa.
                $selecionado = $_POST['option'];

                foreach ($selecionado as $value) {

                    if (isset($_POST['texto'])) {
                        $texto = $texto = addslashes($_POST['texto']);
                    }

                    if (isset($_POST['check'])) {
                        $check = 1;
                    } else {
                        $check = 0;
                    }
                    // Aqui faço insert das opções que foram setadas.
                    $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Baixa de parcelas', '$texto', $value, $check)");
                }

                header("Location: descontos.php?idempreendimento=" . $id);
                die();
            }
        }

        // Rotina Simulação de venda gerada

        if ($request->has('salvar_decima2')) {


            // Verifico se já existe a rotina no banco. 
            $query = DB::select("SELECT * FROM modelo_msg_sms WHERE rotina = 'Simulacao de venda gerada' AND id_empreendimento = $id ");
            if (mysqli_num_rows($query)) {
                while ($result = mysqli_fetch_assoc($query)) {
                    $texto_existe = $result['modelo_msg'];
                }

                $selecionado = $_POST['option'];

                foreach ($selecionado as $value) {

                    if (!empty($_POST['texto'])) {
                        $texto = $texto = addslashes($_POST['texto']);
                    } else {
                        $texto = addslashes($texto_existe);
                    }

                    if (isset($_POST['check'])) {
                        $check = 1;
                    } else {
                        $check = 0;
                    }
                    // Aqui faço update das opções que foram setadas.
                    $query = DB::select("UPDATE modelo_msg_sms SET modelo_msg = '$texto', ativado_desativado = $check WHERE rotina = 'Simulacao de venda gerada' AND grupo_acesso = $value AND id_empreendimento = $id");
                }
                header("Location: descontos.php?idempreendimento=" . $id);
                die();
            } else {
                // Aqui faço a primeira etapa.
                $selecionado = $_POST['option'];

                foreach ($selecionado as $value) {

                    if (isset($_POST['texto'])) {
                        $texto = $texto = addslashes($_POST['texto']);
                    }

                    if (isset($_POST['check'])) {
                        $check = 1;
                    } else {
                        $check = 0;
                    }
                    // Aqui faço insert das opções que foram setadas.
                    $query = DB::select("INSERT INTO modelo_msg_sms (id_empreendimento, rotina, modelo_msg, grupo_acesso, ativado_desativado) VALUES ($id, 'Simulacao de venda gerada', '$texto', $value, $check)");
                }

                header("Location: descontos.php?idempreendimento=" . $id);
                die();
            }
        }
    }
}
