<?php

namespace App;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Cliente extends Authenticatable
{
    use Notifiable;
    protected $guard =  'cliente';
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */ 
    protected $fillable = [
        'nome_cli', 'email_cli', 'senha','cpf_cli', 'rg_cli', 'estadocivil_cli', 'nacionalidade_cli', 'profissao_cli',
        'nascimento_cli', 'obs_cli', 'estado_cli', 'idgrupo', 'imob_id', 'creci', 'insc_municipal', 'data_cadastro', 'alterado_por',
        'data_alterado', 'pessoa', 'idgrupo_cliente', 'cargo', 'salario_base', 'data_contratacao', 'data_demissao', 'foto_cli',
        'cpf_rfb', 'renda_total', 'orgao_expedidor', 'idempreendimento_cadastro', 'imob_id', 'conta_id',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'senha', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_cli_verified_at' => 'datetime',
    ];
}
