<!DOCTYPE html>
<html>

<head>
    <?php echo $__env->make('head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <style>
        @media (max-width: 600px) {
            .btn-cad {

                margin-left: -188px;

            }

        }

        label {
            -webkit-touch-callout: none;
            -webkit-user-select: none;
            -khtml-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
        }
    </style>

</head>

<body>
    <!-- begin #page-loader -->
    <div id="page-loader" class="fade"><span class="spinner"></span></div>
    <!-- end #page-loader -->

    <!-- begin #page-container -->
    <div id="page-container" class="fade in page-sidebar-fixed page-header-fixed">
        <?php echo $__env->make('topo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- begin #header -->
        <!-- end #sidebar -->

        <!-- begin #content -->
        <div id="content" class="content">
            <?php if(\Session::has('success')): ?>
            <div class="alert alert-success  fade in">
                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                <h4 style="box-sizing: border-box;"><?php echo \Session::get('success'); ?></h4>
            </div>
            <?php endif; ?>

            <?php if(\Session::has('error')): ?>
            <div class="alert alert-danger  fade in">
                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                <h4 style="box-sizing: border-box;"><?php echo \Session::get('error'); ?></h4>
            </div>
            <?php endif; ?>

            <h1 class="page-header">Configurações de Contrato - <?php echo e($nomeGestao[0]->nome_fantasia); ?></h1>
            <div class="row">
                <div class="col-md-12">
                    <ul class="nav nav-tabs">
                        <li class="active"><a href="#default-tab-2" data-toggle="tab" aria-expanded="false">Parcelamento Entrada</a></li>
                        <li class=""><a href="#default-tab-1" data-toggle="tab" aria-expanded="false">Descontos</a></li>
                        <li class=""><a href="#default-tab-4" data-toggle="tab" aria-expanded="false">% Minima da Entrada</a></li>
                        <li class=""><a href="#default-tab-3" data-toggle="tab" aria-expanded="false">Plano de Pagamento</a></li>
                        <li class=""><a href="#default-tab-5" data-toggle="tab" aria-expanded="false">Correção de Entrada / Saldo</a></li>
                        <li class=""><a href="#default-tab-6" data-toggle="tab" aria-expanded="false">Equipes</a></li>
                        <li class=""><a href="#default-tab-7" data-toggle="tab" aria-expanded="false">Conta Corrente</a></li>
                        <li class=""><a href="#default-tab-8" data-toggle="tab" aria-expanded="false">Distrato</a></li>
                        <li class=""><a href="#default-tab-9" data-toggle="tab" aria-expanded="false">Serasa</a></li>
                        <li class=""><a href="#default-tab-10" data-toggle="tab" aria-expanded="false">SCPC</a></li>
                        <li class=""><a href="#default-tab-11" data-toggle="tab" aria-expanded="false">SMS</a></li>
                        <li class=""><a href="#default-tab-12" data-toggle="tab" aria-expanded="false">Deletar Gestão</a></li>

                        <!--<li class=""><a href="#default-tab-9" data-toggle="tab" aria-expanded="false">Comissão</a></li>-->
                    </ul>
                    <div class="tab-content">

                        <div class="tab-pane fade" id="default-tab-1">
                            <h3 class="m-t-10"><i class="fa fa-percent" aria-hidden="true"></i> Cadastre os percentuais de descontos</h3>

                            <form action=" <?php echo e(url('/desconto_empre', $idEmp)); ?>" method="POST">
                                <?php echo e(csrf_field()); ?>


                                <div class="form-group col-md-6">
                                    <label class="control-label">% Desconto</label>
                                    <input type="text" class="form-control" id="desconto_empreendimento" name="desconto_empreendimento">
                                </div>
                                <div class="form-group col-md-6">
                                    <label class="control-label">Número maximo Parcelas</label>
                                    <input type="number" class="form-control" id="num_max_parcelas" name="num_max_parcelas">
                                </div>

                                <p class="text-right m-b-0">
                                    <input type="submit" value="Cadastrar" class="btn btn-primary">
                                </p><br>
                            </form>

                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>Desconto</th>

                                        <th>Máximo Parcelas</th>

                                        <th>Ações</th>

                                    </tr>
                                </thead>
                                <tbody>

                                    <?php $__currentLoopData = $desconto_empreendimento; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $descEmp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="odd gradeX">
                                        <td><?php echo e($descEmp->desconto_empreendimento); ?></td>
                                        <td><?php echo e($descEmp->parcela_max); ?></td>
                                        <td>
                                            <a>
                                                <form method="POST" action="<?php echo e(url('/delete_desconto', $descEmp->iddesconto)); ?>">
                                                    <?php echo e(csrf_field()); ?>


                                                    <?php echo e(method_field('DELETE')); ?>

                                                    <input class="btn btn-danger btn-xs" value="Excluir" type="submit" style="font-size:75%;">
                                                </form>
                                            </a>
                                        </td>
                                    </tr>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>

                            </table>
                        </div>

                        <div class="tab-pane fade active in" id="default-tab-2">
                            <h3 class="m-t-10"><i class="fa fa-cog"></i> Cadastre as opções de parcelamento da entrada</h3>
                            <form action=" <?php echo e(url('/parcelamento', $idEmp)); ?>" method="POST">
                                <?php echo e(csrf_field()); ?>


                                <div class="form-group col-md-6">
                                    <label class="control-label">Opções de Parcelamento</label>
                                    <input type="number" min="0" class="form-control" name="parcelamento_entrada">
                                </div>
                                <p class="text-right col-md-12">

                                    <input type="submit" value="Cadastrar" class="btn btn-primary">
                                </p>

                            </form>

                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>Parcelas</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $parcelamento; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parcelamento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="odd gradeX">
                                        <td><?php echo e($parcelamento->parcelamento_entrada); ?></td>
                                        <!-- <td><a href=""> <span class="label label-danger">Excluir</span> </a></td> -->
                                        <td>
                                            <a>
                                                <form method="POST" action="<?php echo e(url('/delete_parcelamento', $parcelamento->idparcelamento_entrada)); ?>">
                                                    <?php echo e(csrf_field()); ?>


                                                    <?php echo e(method_field('DELETE')); ?>

                                                    <input class="btn btn-danger btn-xs" value="Excluir" type="submit" style="font-size:75%;">
                                                </form>
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>

                        <div class="tab-pane fade" id="default-tab-4">
                            <h3 class="m-t-10"><i class="fa fa-percent" aria-hidden="true"></i> Informe o percentual minimo da Entrada</h3>
                            <form action=" <?php echo e(url('/minimo', $idEmp)); ?>" method="POST">
                                <?php echo e(csrf_field()); ?>

                                <div class="form-group">
                                    <label class="col-md-12 control-label">% Minimo de Entrada</label>
                                    <div class="col-md-6">

                                        <input type="text" class="form-control" id="percentual_entrada" name="percentual_entrada" <?php if(isset($entradaMin[0]->percentual_entrada)): ?>
                                        <?php if($entradaMin[0]->percentual_entrada != '' ): ?> value="<?php echo e($entradaMin[0]->percentual_entrada); ?>" <?php endif; ?>
                                        <?php endif; ?>
                                        >
                                    </div>
                                </div>
                                <p class="text-right m-b-0">
                                    <input type="submit" value="Cadastrar" class="btn btn-primary">
                                </p>
                            </form>
                        </div>

                        <div class="tab-pane fade" id="default-tab-3">
                            <h3 class="m-t-10"><i class="fa fa-money" aria-hidden="true"></i> Informe o plano de pagamento Maximo</h3>
                            <form action=" <?php echo e(url('/plano_pagamento', $idEmp)); ?>" method="POST">
                                <?php echo e(csrf_field()); ?>

                                <div class="form-group">
                                    <label class="col-md-12 control-label">Plano de Pagamento Maximo </label>
                                    <div class="col-md-6">

                                        <input type="number" min="0" class="form-control" name="plano_pagamento" <?php if(isset($pagamentoMax[0]->plano_pagamento)): ?>
                                        <?php if($pagamentoMax[0]->plano_pagamento != '' ): ?> value="<?php echo e($pagamentoMax[0]->plano_pagamento); ?>" <?php endif; ?>
                                        <?php endif; ?>
                                        >
                                    </div>
                                </div>
                                <p class="text-right m-b-0">

                                    <input type="submit" value="Cadastrar" class="btn btn-primary">
                                </p>

                            </form>

                        </div>

                        <div class="tab-pane fade" id="default-tab-5">
                            <h3 class="m-t-10"><i class="fa fa-percent" aria-hidden="true"></i> Informe os percentuais para correção</h3>
                            <form action=" <?php echo e(url('/correcao_entrada', $idEmp)); ?>" method="POST">
                                <?php echo e(csrf_field()); ?>

                                <div class="form-group col-md-6 ">
                                    <label class="control-label">Correção Entrada </label>

                                    <input type="text" class="form-control" id="taxa_entrada" name="taxa_entrada" <?php if(isset($Correcao[0]->taxa_entrada)): ?>
                                    <?php if($Correcao[0]->taxa_entrada != '' ): ?> value="<?php echo e($Correcao[0]->taxa_entrada); ?>" <?php endif; ?>
                                    <?php endif; ?>
                                    >
                                    <div id="coloca_entrada_aqui">
                                    </div>
                                </div>

                                <div class="form-group col-md-6">
                                    <label class="control-label">Correção Saldo Devedor </label>

                                    <input type="text" class="form-control" id="taxa_financiamento" name="taxa_financiamento" <?php if(isset($Correcao[0]->taxa_financiamento)): ?>
                                    <?php if($Correcao[0]->taxa_financiamento != '' ): ?> value="<?php echo e($Correcao[0]->taxa_financiamento); ?>" <?php endif; ?>
                                    <?php endif; ?>
                                    >

                                    <div id="coloca_saldo_aqui">
                                    </div>
                                </div>

                                <div class="form-group col-md-6">

                                    <label class="control-label">Taxa Financiamento</label>
                                    <input class="form-control" type="text" name="taxa_financiamento_vdd" id="taxa_financiamento_vdd" <?php if(isset($EntradaInter[0]->juros_financiamento)): ?>
                                    <?php if($EntradaInter[0]->juros_financiamento != '' ): ?> value="<?php echo e($EntradaInter[0]->juros_financiamento); ?>" <?php endif; ?>
                                    <?php endif; ?>
                                    >
                                </div>

                                <div class="form-group col-md-6">
                                    <label class="control-label">Intermediarias % lote</label>

                                    <input type="text" class="form-control" id="percen_lote" name="percen_lote" <?php if(isset($EntradaInter[0]->percen_lote)): ?>
                                    <?php if($EntradaInter[0]->percen_lote != '' ): ?> value="<?php echo e($EntradaInter[0]->percen_lote); ?>" <?php endif; ?>
                                    <?php endif; ?>
                                    >
                                </div>
                                <!--  <div class="row"> -->

                                <div class="form-group col-md-6">
                                    <label class="control-label">Intermediarias Taxa de Juros</label>
                                    <input type="text" class="form-control" id="taxa_inter" name="taxa_inter" <?php if(isset($EntradaInter[0]->taxa_inter)): ?>
                                    <?php if($EntradaInter[0]->taxa_inter != '' ): ?> value="<?php echo e($EntradaInter[0]->taxa_inter); ?>" <?php endif; ?>
                                    <?php endif; ?>
                                    >
                                </div>
                                <div class="row">
                                </div>
                                <!--  </div><br> -->

                                <div class="form-group col-md-4">
                                    <label class="control-label">Travar Taxa Financiamento?</label><br>
                                    <input type="checkbox" id="travar_financiamento_vdd" name="travar_financiamento_vdd" value="1" <?php if(isset($EntradaInter[0]->taxa_inter)): ?>
                                    <?php if($EntradaInter[0]->taxa_inter != '' ): ?> checked <?php endif; ?>
                                    <?php endif; ?>
                                    >
                                    <label for="travar_financiamento_vdd">Sim</label>
                                </div>

                                <div class="form-group col-md-4">
                                    <label class="control-label">Correção Saldo Devedor Fixo?</label><br>
                                    <input type="checkbox" id="correcao_finan_fixo" name="correcao_finan_fixo" value="1" <?php if(isset($Correcao[0]->correcao_finan_fixo)): ?>
                                    <?php if($Correcao[0]->correcao_finan_fixo != '' ): ?> checked <?php endif; ?>
                                    <?php endif; ?>
                                    >
                                    <label for="correcao_finan_fixo">Sim</label>

                                </div>

                                <div class="form-group col-md-4">
                                    <label class="control-label">Ativar Intermediarias?</label><br>

                                    <input type="checkbox" id="status" name="status" value="1" <?php if(isset($EntradaInter[0]->status_ativo)): ?>
                                    <?php if($EntradaInter[0]->status_ativo != '' ): ?> checked <?php endif; ?>
                                    <?php endif; ?>
                                    >
                                    <label for="status">Sim</label>

                                </div>

                                <div class="form-group col-md-4">
                                    <label class="control-label">Travar Intermediarias?</label><br>

                                    <input type="checkbox" id="trava_inter" name="trava_inter" value="1" <?php if(isset($EntradaInter[0]->trava_inter)): ?>
                                    <?php if($EntradaInter[0]->trava_inter != '' ): ?> checked <?php endif; ?>
                                    <?php endif; ?>
                                    >
                                    <label for="trava_inter">Sim</label>

                                </div>

                                <div class="form-group col-md-4">
                                    <label class="control-label">Ativar Parcela Única?</label><br>


                                    <input type="checkbox" id="parcela_unica" name="parcela_unica" value="1" <?php if(isset($EntradaInter[0]->status_parc_unica)): ?>
                                    <?php if($EntradaInter[0]->status_parc_unica != '' ): ?> checked <?php endif; ?>
                                    <?php endif; ?>
                                    >
                                    <label for="parcela_unica">Sim</label>

                                </div>

                                <div class="form-group col-md-4">
                                    <label class="control-label">Sistema de Armotização</label><br>

                                    <input name="price" id="price" type="checkbox" value="1" <?php if(isset($EntradaInter[0]->price)): ?>
                                    <?php if($EntradaInter[0]->price != '' ): ?> checked <?php endif; ?>
                                    <?php endif; ?>
                                    />
                                    <label for="price">Price</label>

                                    <input name="sac" id="sac" type="checkbox" value="1" <?php if(isset($EntradaInter[0]->sac)): ?>
                                    <?php if($EntradaInter[0]->sac != '' ): ?> checked <?php endif; ?>
                                    <?php endif; ?>
                                    />
                                    <label for="sac">SAC</label>

                                    <input name="semjuros" id="semjuros" type="checkbox" value="1" <?php if(isset($EntradaInter[0]->semjuros)): ?>
                                    <?php if($EntradaInter[0]->semjuros != '' ): ?> checked <?php endif; ?>
                                    <?php endif; ?>
                                    />
                                    <label for="semjuros">Juros</label>

                                </div>

                                <p class="text-right m-b-0">
                                    <input type="submit" value="Cadastrar" class="btn btn-primary">
                                </p>

                            </form>

                        </div>

                        <div class="tab-pane fade" id="default-tab-6">

                            <h3 class="m-t-10"><i class="fa fa-percent" aria-hidden="true"></i> Informe percentual Geral da comissão da Equipe</h3>

                            <form action=" <?php echo e(url('/percentual_comissao_geral', $idEmp)); ?>" method="POST">
                                <?php echo e(csrf_field()); ?>

                                <div class="form-group col-md-6" id="repasse_comissao"><label><strong>Comissao Geral da Equipe:</strong> </label>
                                    <input placeholder='% Comissão Equipe' class='form-control maskk' required type='text' min="1" max="100" name='comissao_equipe'><br></div>

                                <p class="text-right m-b-0">
                                    <input type="submit" value="Cadastrar" class="btn btn-primary">
                                </p>
                            </form>
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>Comissao Total da equipe</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $PercentualComissao; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $percentual): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="odd gradeX">
                                        <td><?php echo e($percentual->percentualgeral); ?></td>
                                        <td>
                                            <a>
                                                <form method="POST" action="<?php echo e(url('/delete_comissao', $percentual->idcomissaogeral)); ?>">
                                                    <?php echo e(csrf_field()); ?>


                                                    <?php echo e(method_field('DELETE')); ?>

                                                    <input class="btn btn-danger btn-xs" value="Excluir" type="submit" style="font-size:75%;">
                                                </form>
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>

                            <hr class="hr1">

                            <h3 class="m-t-10"><i class="fa fa-percent" aria-hidden="true"></i> Informe as equipes desse empreendimento</h3>
                            <form action=" <?php echo e(url('/equipe_empreendimento', $idEmp)); ?>" method="POST">
                                <?php echo e(csrf_field()); ?>

                                <div class="form-group col-md-6">
                                    <label class="control-label">Equipe </label>
                                    <select class="form-control" name="equipe_v" id="equipe_venda">
                                        <option value="">Selecione</option>
                                        <?php $__currentLoopData = $listaEquipe; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $equipe): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <option value="<?php echo e($equipe->idcliente); ?>"><?php echo e($equipe->nome_cli); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </select>
                                </div>

                                <div class="form-group" id="result_equipe"></div>



                                <p class="text-right m-b-0">

                                    <input type="submit" value="Cadastrar" class="btn btn-primary">
                                </p>

                            </form>
                            <br>
                            <br>
                            <br>
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>Imobiliaria / Equipe</th>
                                        <th>Detalhes</th>
                                        <th>Ações</th>

                                    </tr>
                                </thead>
                                <tbody>

                                    <?php $__currentLoopData = $equipeCadastrada; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $equipeCad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="odd gradeX">
                                        <td><?php echo e($equipeCad->nome_cli); ?><input type="hidden" id="pega_imob" value="<?php echo e($equipeCad->idcliente); ?>"></td>
                                        <td><a href="#detalhe_equipe" data-toggle='modal' id="lancomissao" data-target='#detalhe_equipe'><label class="label label-primary" onclick="chama_detalhe()" id="moddet">Detalhes</label></a></td>
                                        <td>
                                            <a>
                                                <form method="POST" action="<?php echo e(url('/delete_equipe', $equipeCad->idempreendimento_imob)); ?>">
                                                    <?php echo e(csrf_field()); ?>


                                                    <?php echo e(method_field('DELETE')); ?>

                                                    <input class="btn btn-danger btn-xs" value="Excluir" type="submit" style="font-size:75%;">
                                                </form>
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                </tbody>
                            </table>

                            <hr class="hr1">
                            <h3 class="m-t-10"><i class="fa fa-percent" aria-hidden="true"></i> Informe Percentual de Repasse Mensal para a equipe</h3>

                            <form action=" <?php echo e(url('/repasse', $idEmp)); ?>" method="POST">
                                <?php echo e(csrf_field()); ?>


                                <div class="form-group col-md-6" id="repasse_comissao"><label><strong>Repasse mensal de:</strong> </label>
                                    <input placeholder='% Repasse' class='form-control  maskk' required type='text' min="1" max="100" name='repasse_equipe'><br></div>



                                <p class="text-right m-b-0">
                                    <input type="submit" value="Cadastrar" class="btn btn-primary">
                                </p>
                            </form>
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>Repasse Comissao do Empreendimento</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php $__currentLoopData = $ListaRepasse; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $repasse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="odd gradeX">
                                        <td><?php echo e($repasse->percentual); ?></td>
                                        <td>
                                            <a>
                                                <form method="POST" action="<?php echo e(url('/delete_repasse', $repasse->idrepasse)); ?>">
                                                    <?php echo csrf_field(); ?>

                                                    <?php echo e(method_field('DELETE')); ?>

                                                    <input class="btn btn-danger btn-xs" value="Excluir" type="submit" style="font-size:75%;">
                                                </form>
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>

                        <div class="tab-pane fade" id="default-tab-7">
                            <h3 class="m-t-12"><i class="fa fa-link" aria-hidden="true"></i>Vincular Conta Corrente</h3>
                            <form action=" <?php echo e(url('/centro_receitas', $idEmp)); ?>" method="POST">
                                <?php echo e(csrf_field()); ?>

                                <fieldset>
                                    <div class="row">
                                        <div class="form-group col-md-6">
                                            <label class="control-label">Conta Corrente</label>
                                            <select class="form-control" name="contacorrente" required="">
                                                <option value="">Escolha</option>
                                                <?php $__currentLoopData = $listarContas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lista): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($lista->idcontacorrente); ?>"><?php echo e($lista->descricao_conta); ?> - <?php echo e($lista->banco); ?> - <?php echo e($lista->nome_banco); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="text-right block3">

                                        <p>
                                            <input type="submit" value="Cadastrar" class="btn btn-primary">
                                        </p>
                                    </div>
                                </fieldset>
                            </form>
                        </div>

                        <div class="tab-pane fade" id="default-tab-8">
                            <h3 class="m-t-10"><i class="fa fa-cog"></i> Informe os dados sobre Distrato</h3>
                            <form action=" <?php echo e(url('/distrato', $idEmp)); ?>" method="POST">
                                <?php echo e(csrf_field()); ?>

                                <div class="form-group col-md-4">
                                    <label class="control-label">Descrição Custo </label>
                                    <input type="text" id="descricao_custo" name="descricao_custo" class="form-control" required="">
                                </div>

                                <div class="form-group col-md-4">
                                    <label class="control-label">% de desconto </label>
                                    <input type="text" id="percentual_custo" name="percentual_custo" class="form-control" required="">
                                </div>

                                <div class="form-group col-md-4">
                                    <label class="control-label">Impacto do Custo </label>
                                    <select class="form-control" name="impacto_custo" required="">
                                        <option value="">Escolha</option>
                                        <option value="1">Valor do Contrato</option>
                                        <option value="2">Valor Pago</option>
                                    </select>
                                </div>

                                <p class="text-right m-b-12">
                                    <input type="submit" value="Cadastrar" class="btn btn-primary">
                                </p>

                            </form>
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>Descrição do Custo</th>
                                        <th>% de custo</th>
                                        <th>Impacto do Custo</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $Distrato; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="odd gradeX">
                                        <td><?php echo e($dist->descricao_custo); ?></td>
                                        <td><?php echo e($dist->percentual_custo); ?></td>
                                        <td><?php echo e($dist->impacto_custo); ?></td>
                                        <td>
                                            <a>
                                                <form method="POST" action="<?php echo e(url('/delete_distrato', $dist->idcusto_distrato)); ?>">
                                                    <?php echo e(csrf_field()); ?>


                                                    <?php echo e(method_field('DELETE')); ?>

                                                    <input class="btn btn-danger btn-xs" value="Excluir" type="submit" style="font-size:75%;">
                                                </form>
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>

                        <!-- Inicio Serasa -->
                        <div class="tab-pane fade" id="default-tab-9">
                            <div class="panel-body">
                                <h3 class="m-t-10"><i class="fa fa-cog"></i> Informe os dados sobre o Serasa</h3>
                                <form action=" <?php echo e(url('/serasa', $idEmp)); ?>" method="POST">
                                    <?php echo e(csrf_field()); ?>

                                    <div class="row">
                                        <div class="col-md-6 form-group">
                                            <label class=" control-label">E-mail </label>
                                            <input class=form-control type="text" name="email" <?php if(isset($Serasa[0]->email)): ?>
                                            <?php if($Serasa[0]->email != '' ): ?> value="<?php echo e($Serasa[0]->email); ?>" <?php endif; ?>
                                            <?php endif; ?>
                                            >
                                        </div>

                                        <div class="col-md-6 form-group">
                                            <label class="control-label">Senha </label>
                                            <div class="input-group">
                                                <input class=form-control type="password" name="senha" id="senha1" <?php if(isset($Serasa[0]->senha)): ?>
                                                <?php if($Serasa[0]->senha != '' ): ?> value="<?php echo e($Serasa[0]->senha); ?>" <?php endif; ?>
                                                <?php endif; ?>
                                                >
                                                <span class="input-group-addon">
                                                    <i class="fa fa-eye" id="olho1" style="background:transparent;border:none"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 form-group">
                                            <label class="control-label">Total Ocorrencias</label>
                                            <input class=form-control type="text" name="total_ocorrencias" <?php if(isset($Serasa[0]->total_ocorre)): ?>
                                            <?php if($Serasa[0]->total_ocorre != '' ): ?> value="<?php echo e($Serasa[0]->total_ocorre); ?>" <?php endif; ?>
                                            <?php endif; ?>
                                            >
                                        </div>

                                        <div class="col-md-6 form-group">
                                            <label class="control-label">Dia da Ocorrencia</label>
                                            <input class=form-control type="text" name="data_ocorrencia" <?php if(isset($Serasa[0]->data_ocorre)): ?>
                                            <?php if($Serasa[0]->data_ocorre != '' ): ?> value="<?php echo e($Serasa[0]->data_ocorre); ?>" <?php endif; ?>
                                            <?php endif; ?>
                                            >
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 form-group">
                                            <label class="control-label">Valor total das Ocorrencias</label>
                                            <input class=form-control type="text" name="valor_total_ocorrencia" id="dinheiro" <?php if(isset($Serasa[0]->valor_total_ocorre)): ?>
                                            <?php if($Serasa[0]->valor_total_ocorre != '' ): ?> value="R$ <?php echo e($Serasa[0]->valor_total_ocorre); ?>" <?php endif; ?>
                                            <?php endif; ?>
                                            >
                                        </div>

                                        <div class="col-md-6 form-group">
                                            <label class="control-label">Valor de Risk Score </label>
                                            <input class=form-control type="text" name="valor_riskSore" <?php if(isset($Serasa[0]->valor_Sore)): ?>
                                            <?php if($Serasa[0]->valor_Sore != '' ): ?> value="<?php echo e($Serasa[0]->valor_Sore); ?>" <?php endif; ?>
                                            <?php endif; ?>
                                            >
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <input type="checkbox" name="sem_consulta" value="1" id="falter" <?php if(isset($Serasa[0]->consulta)): ?>
                                            <?php if($Serasa[0]->consulta == 1 ): ?> checked <?php endif; ?>
                                            <?php endif; ?>

                                            ><label for="falter" style="color:#000000;">Com consulta.</label>
                                            <br>
                                            <input type="checkbox" disabled="true" class="aparece" name="aprova_automatico" id="aprova" value="1" <?php if(isset($Serasa[0]->chec)): ?>
                                            <?php if($Serasa[0]->chec == 1 ): ?> checked <?php endif; ?>
                                            <?php endif; ?>
                                            ><label for="aprova" style="color:#000000;">Aprova automatico.</label>
                                            <br>
                                            <input type="checkbox" disabled="true" class="aparece" name="consulta_RiskSore" id="riksore" value="1" <?php if(isset($Serasa[0]->nenhum)): ?>
                                            <?php if($Serasa[0]->nenhum == 1 ): ?> checked <?php endif; ?>
                                            <?php endif; ?>
                                            > <label for="riksore" style="color:#000000;">Consulta Risk Score.</label>
                                        </div>
                                        <div class="col-md-6">
                                            <br>
                                            <br>
                                            <p class="text-right m-b-0">
                                                <input type="submit" value="Cadastrar" name="grava_serasa" class="btn btn-primary">
                                            </p>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <!-- Inicio SPC -->
                        <div class="tab-pane fade" id="default-tab-10">
                            <div class="panel-body">
                                <h3 class="m-t-10"><i class="fa fa-cog"></i> Informe os dados do SCPC</h3>
                                <form action=" <?php echo e(url('/scpc', $idEmp)); ?>" method="POST">
                                    <?php echo e(csrf_field()); ?>


                                    <div class="row">
                                        <div class="col-md-4 form-group">
                                            <label class="control-label">Token de Acesso</label>
                                            <input class=form-control type="text" name="token" <?php if(isset($Scpc[0]->token_spc)): ?>
                                            <?php if($Scpc[0]->token_spc != '' ): ?> value="<?php echo e($Scpc[0]->token_spc); ?>" <?php endif; ?>
                                            <?php endif; ?>
                                            >
                                        </div>

                                        <div class="col-md-4 form-group">
                                            <label class="control-label">Senha</label>
                                            <div class="input-group">
                                                <input class="form-control" type="password" name="senha" id="senha2" <?php if(isset($Scpc[0]->senha_spc)): ?>
                                                <?php if($Scpc[0]->senha_spc != '' ): ?> value="<?php echo e($Scpc[0]->senha_spc); ?>" <?php endif; ?>
                                                <?php endif; ?>
                                                >
                                                <span class="input-group-addon">
                                                    <i class="fa fa-eye" id="olho2" style="background:transparent;border:none"></i>
                                                </span>
                                            </div>
                                        </div>

                                        <div class="col-md-4 form-group">
                                            <label class="control-label">Código de serviço do associado</label>
                                            <input class=form-control type="text" name="codigo_servico_associado" <?php if(isset($Scpc[0]->codigo_servico_spc)): ?>
                                            <?php if($Scpc[0]->codigo_servico_spc != '' ): ?> value="<?php echo e($Scpc[0]->codigo_servico_spc); ?>" <?php endif; ?>
                                            <?php endif; ?>
                                            >
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4 form-group">
                                            <label class="control-label">Codigo do Associado</label>
                                            <input class=form-control type="text" name="codigo_associado" <?php if(isset($Scpc[0]->codigo_associado_spc)): ?>
                                            <?php if($Scpc[0]->codigo_associado_spc != '' ): ?> value="<?php echo e($Scpc[0]->codigo_associado_spc); ?>" <?php endif; ?>
                                            <?php endif; ?>
                                            >
                                        </div>

                                        <div class="col-md-4 form-group">
                                            <label class="control-label">Entidade da Associação</label>
                                            <input class=form-control type="text" name="entidade_associado" <?php if(isset($Scpc[0]->entidade_spc)): ?>
                                            <?php if($Scpc[0]->entidade_spc != '' ): ?> value="<?php echo e($Scpc[0]->entidade_spc); ?>" <?php endif; ?>
                                            <?php endif; ?>
                                            >
                                        </div>

                                        <div class="col-md-4 form-group">
                                            <label class="control-label">Tipo de Credito</label>
                                            <select class="form-control" data-size="10" data-style="btn-white" name="tipo_credito">
                                                <option>Selecione o credito</option>
                                                <option value="CD" <?php if(isset($Scpc[0]->tipo_credito_spc)): ?>
                                                    <?php if($Scpc[0]->tipo_credito_spc == 'CD' ): ?> selected <?php endif; ?>
                                                    <?php endif; ?>
                                                    > CD - Crédito Direto</option>
                                                <option value="CP" <?php if(isset($Scpc[0]->tipo_credito_spc)): ?>
                                                    <?php if($Scpc[0]->tipo_credito_spc == 'CP' ): ?> selected <?php endif; ?>
                                                    <?php endif; ?>
                                                    > CP - Crédito Pessoal</option>
                                                <option value="CV" <?php if(isset($Scpc[0]->tipo_credito_spc)): ?>
                                                    <?php if($Scpc[0]->tipo_credito_spc == 'CV' ): ?> selected <?php endif; ?>
                                                    <?php endif; ?>
                                                    > CV - Crédito de Veículos</option>
                                                <option value="CH" <?php if(isset($Scpc[0]->tipo_credito_spc)): ?>
                                                    <?php if($Scpc[0]->tipo_credito_spc == 'CH' ): ?> selected <?php endif; ?>
                                                    <?php endif; ?>
                                                    > CH - Cheque</option>
                                                <option value="CC" <?php if(isset($Scpc[0]->tipo_credito_spc)): ?>
                                                    <?php if($Scpc[0]->tipo_credito_spc == 'CC' ): ?> selected <?php endif; ?>
                                                    <?php endif; ?>
                                                    > CC - Cartão de Crédito</option>
                                                <option value="OU" <?php if(isset($Scpc[0]->tipo_credito_spc)): ?>
                                                    <?php if($Scpc[0]->tipo_credito_spc == 'OU' ): ?> selected <?php endif; ?>
                                                    <?php endif; ?>
                                                    > OU - Outros </option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4 form-group">
                                            <label class="control-label">Telefone</label>
                                            <input class=form-control type="text" name="telefone_associado" <?php if(isset($Scpc[0]->telefone_spc)): ?>
                                            <?php if($Scpc[0]->telefone_spc != '' ): ?> value="<?php echo e($Scpc[0]->telefone_spc); ?>" <?php endif; ?>
                                            <?php endif; ?>
                                            >
                                        </div>

                                        <div class="col-md-4 form-group">
                                            <label class="control-label">DDD</label>
                                            <input class=form-control type="text" name="ddd_associado" <?php if(isset($Scpc[0]->ddd_spc)): ?>
                                            <?php if($Scpc[0]->ddd_spc != '' ): ?> value="<?php echo e($Scpc[0]->ddd_spc); ?>" <?php endif; ?>
                                            <?php endif; ?>
                                            >
                                        </div>

                                        <div class="col-md-4 form-group">
                                            <label class="control-label">Modelo do Score</label>
                                            <input class=form-control type="text" name="modelo_score_associado" <?php if(isset($Scpc[0]->modelo_score_spc)): ?>
                                            <?php if($Scpc[0]->modelo_score_spc != '' ): ?> value="<?php echo e($Scpc[0]->modelo_score_spc); ?>" <?php endif; ?>
                                            <?php endif; ?>
                                            >
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4 form-group">
                                            <label class="control-label">Deseja Realmente Fazer a Consulta</label>
                                            <select class="form-control" data-size="10" data-style="btn-white" name="com_spc">
                                                <option>Selecione</option>
                                                <option value="1" <?php if(isset($Scpc[0]->com_spc)): ?>
                                                    <?php if($Scpc[0]->com_spc == 1 ): ?> selected <?php endif; ?>
                                                    <?php endif; ?>
                                                    >SIM </option>
                                                <option value="0" <?php if(isset($Scpc[0]->com_spc)): ?>
                                                    <?php if($Scpc[0]->com_spc == 0 ): ?> selected <?php endif; ?>
                                                    <?php endif; ?>
                                                    >Não </option>
                                            </select>
                                        </div>

                                        <div class="col-md-4 form-group">
                                            <label class="control-label">Consulta Cheque</label>
                                            <select class="form-control" data-size="10" data-style="btn-white" name="com_cheque">
                                                <option>Selecione</option>
                                                <option value="1" <?php if(isset($Scpc[0]->consulta_cheque_spc)): ?>
                                                    <?php if($Scpc[0]->consulta_cheque_spc == 1 ): ?> selected <?php endif; ?>
                                                    <?php endif; ?>
                                                    >SIM </option>
                                                <option value="0" <?php if(isset($Scpc[0]->consulta_cheque_spc)): ?>
                                                    <?php if($Scpc[0]->consulta_cheque_spc == 0 ): ?> selected <?php endif; ?>
                                                    <?php endif; ?>
                                                    >Não </option>
                                            </select>
                                        </div>

                                        <div class="col-md-4 form-group">
                                            <label class="control-label">Aprovação Automatica</label>
                                            <select class="form-control" data-size="10" data-style="btn-white" name="aprova_auto_spc">
                                                <option>Selecione</option>
                                                <option value="1" <?php if(isset($Scpc[0]->aprovar_automatico_spc)): ?>
                                                    <?php if($Scpc[0]->aprovar_automatico_spc == 1 ): ?> selected <?php endif; ?>
                                                    <?php endif; ?>
                                                    > SIM</option>
                                                <option value="0" <?php if(isset($Scpc[0]->aprovar_automatico_spc)): ?>
                                                    <?php if($Scpc[0]->aprovar_automatico_spc == 0 ): ?> selected <?php endif; ?>
                                                    <?php endif; ?>
                                                    > Não</option>
                                            </select>
                                        </div>

                                    </div>

                                    <div class="row">
                                        <div class="col-md-4 form-group">
                                            <label class="control-label">Total do Score Desejado</label>
                                            <input class=form-control type="text" name="total_score_spc" <?php if(isset($Scpc[0]->score_spc)): ?>
                                            <?php if($Scpc[0]->score_spc != '' ): ?> value="<?php echo e($Scpc[0]->score_spc); ?>" <?php endif; ?>
                                            <?php endif; ?>
                                            >
                                        </div>

                                        <div class="col-md-4 form-group">
                                            <label class="control-label">Total Maximo dos Debitos</label>
                                            <input class=form-control type="text" name="total_debitos_spc" <?php if(isset($Scpc[0]->total_debitos_spc)): ?>
                                            <?php if($Scpc[0]->total_debitos_spc != '' ): ?> value="<?php echo e($Scpc[0]->total_debitos_spc); ?>" <?php endif; ?>
                                            <?php endif; ?>
                                            >
                                        </div>

                                        <div class="col-md-4 form-group">
                                            <label class="control-label">Valor Maximo dos Debitos</label>
                                            <input class=form-control type="text" name="valor_maximo_spc" id="dinheiro2" <?php if(isset($Scpc[0]->valor_acumulado_spc)): ?>
                                            <?php if($Scpc[0]->valor_acumulado_spc != '' ): ?> value="<?php echo e($Scpc[0]->valor_acumulado_spc); ?>" <?php endif; ?>
                                            <?php endif; ?>
                                            >
                                        </div>

                                    </div>

                                    <div class="row">

                                        <div class="col-md-4 form-group">
                                            <label class="control-label">Data Maxima dos Debitos (Em dias)</label>
                                            <input class=form-control type="text" name="data_maxima_spc" <?php if(isset($Scpc[0]->data_primeiro_debito_spc)): ?>
                                            <?php if($Scpc[0]->data_primeiro_debito_spc != '' ): ?> value="<?php echo e($Scpc[0]->data_primeiro_debito_spc); ?>" <?php endif; ?>
                                            <?php endif; ?>
                                            >
                                        </div>
                                        <div class="col-md-4 form-group">
                                            <input id="primeira_parcela" type="checkbox" name="primeira_parcela" <?php if(isset($Scpc[0]->data_primeiro_debito_spc)): ?>
                                            <?php if($Scpc[0]->data_primeiro_debito_spc != '' ): ?> value="<?php echo e($Scpc[0]->data_primeiro_debito_spc); ?>" <?php endif; ?>
                                            <?php endif; ?>
                                            >
                                            <label for="primeira_parcela" class="control-label">Lançar primeira parcela ao aprovar proposta?</label>
                                        </div>

                                        <br>
                                        <div class="col-md-4">
                                            <br>
                                            <p class="text-right m-b-0">
                                                <input type="submit" value="Cadastrar" name="grava_spc" class="btn btn-primary">
                                            </p>
                                        </div>

                                    </div>
                                </form>
                            </div>
                        </div>

                        <!-- Inicio SMS -->
                        <div class="tab-pane fade" id="default-tab-11">
                            <div class="row">
                                <div class="panel-body">
                                    <h3 class="m-t-10"><i class="fa fa-envelope" aria-hidden="true"></i> Disparos de SMS</h3>
                                    <br>
                                    <div style="border-radius: 5px; border: solid 1px #000;  margin-left: 30px; margin-right: 16px;">
                                        <div style="border-radius: 5px;">
                                            <p style="color: #000; font-size: 14px; text-align: center; margin-top: 6px;"> <strong> Exemplo de uso:</strong>
                                                <strong style="color: gray;"> Olá @cliente_nome, o vencimento de sua @numero-parcela º parcela está chegando (@data-vencimento). </strong><br>
                                                <strong> Mensagem final:</strong>
                                                <strong style="color: gray;"> Olá Lucas, o vencimento de sua 20 º parcela está chegando (31/07/2020). </strong>
                                            </p>
                                        </div>
                                        <br>
                                        <p style="text-align: center;">
                                            <strong style="color: #000; font-size: 14px; text-align: center; margin-top: 6px;">Variáveis disponiveis</strong><br>
                                            <strong> @nome  &nbsp</strong>
                                            <strong>@sobrenome  &nbsp</strong>
                                            <strong>@empreendimento  &nbsp</strong>
                                            <strong>@quadra  &nbsp</strong>
                                            <strong>@lote  &nbsp</strong>
                                            <strong>@data-vencimento &nbsp</strong>
                                            <strong>@numero-parcela &nbsp</strong>
                                            <strong>@valor-parcela &nbsp</strong>
                                            <strong>@codigo-barra &nbsp</strong>
                                            <strong>@tempo-atraso &nbsp</strong>
                                            <strong>@telefone  &nbsp</strong>
                                            <strong>@lead_nome  &nbsp</strong>
                                            <strong>@cliente_nome  </strong>

                                        </p>
                                        <br>
                                        <p style="text-align: center; color:#ff2929; font-size: 18px;">
                                            <strong>Atenção:</strong>
                                            <strong> A mensagem deve conter no maximo 160 caracteres (incluindo as variáveis).</strong>
                                        </p>
                                    </div>
                                    <br>

                                    <div class="col-md-12">
                                        <div class="panel panel-inverse">
                                            <div class="panel-body" id="barra">
                                                <table id="data-table" class="table table-striped table-bordered">
                                                    <thead>
                                                        <tr>
                                                            <th><strong> Descrição</strong></th>
                                                            <th><strong> Selecione </strong></th>
                                                            <th><strong> Texto da Mensagem </strong></th>
                                                            <th style="width:60px;"><strong> Liga/Desliga </strong></th>
                                                            <th style="width:60px;"><strong> Salvar </strong></th>

                                                        </tr>
                                                    </thead>
                                                    <tbody>

                                                        <tr>
                                                            <input type="hidden" value="<?php echo e($randomic = rand(11111, 99999)); ?>">
                                                            <form action="<?php echo e(route('empreendimentos.sms', $idEmp)); ?>" id="<?php echo e($randomic); ?>" method="POST"></form>
                                                            <meta name="csrf-token" form="<?php echo e($randomic); ?>" content="<?php echo e(csrf_token()); ?>">
                                                            <?php echo method_field('POST'); ?>

                                                            <td><strong>Leads Cadastrados (site): </strong></td>
                                                            <td>
                                                                <select class="selectpicker" multiple="multiple" name="option[]" form="<?php echo e($randomic); ?>">
                                                                    <option value="5"> Administrador</option>
                                                                    <option value="7"> Corretor</option>
                                                                    <option value="6"> Imobiliaria</option>
                                                                </select>
                                                            </td>

                                                            <td>
                                                                <textarea class="editar" rows="2" cols="40" name="texto" maxlength="160" form="<?php echo e($randomic); ?>"></textarea>
                                                            </td>
                                                            <td>
                                                                <input type="checkbox" name="check" form="<?php echo e($randomic); ?>" data-toggle="toggle">
                                                            </td>
                                                            <td>
                                                                <input type="submit" form="<?php echo e($randomic); ?>" value="Salvar" name="salvar_primeiro" class="btn btn-primary">
                                                            </td>

                                                        </tr>

                                                        <tr>
                                                            <input type="hidden" value="<?php echo e($randomic = rand(11111, 99999)); ?>">


                                                            <form action="<?php echo e(route('empreendimentos.sms', $idEmp)); ?>" id="<?php echo e($randomic); ?>" method="POST"></form>
                                                            <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
                                                            <?php echo method_field('POST'); ?>

                                                            <td><strong>Leads do dia Corretores / Imobiliárias:</strong></td>
                                                            <td>
                                                                <select class="selectpicker" multiple="multiple" name="option[]" form="<?php echo e($randomic); ?>">
                                                                    <option value="5"> Administrador</option>
                                                                    <option value="7"> Corretor</option>
                                                                    <option value="6"> Imobiliaria</option>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <textarea class="editar" rows="2" cols="40" name="texto" maxlength="160" form="<?php echo e($randomic); ?>"></textarea>

                                                            </td>
                                                            <td>
                                                                <input type="checkbox" name="check" form="<?php echo e($randomic); ?>" data-toggle="toggle">
                                                            </td>
                                                            <td>
                                                                <input type="submit" form="<?php echo e($randomic); ?>" value="Salvar" name="salvar_segundo" class="btn btn-primary">
                                                            </td>
                                                        </tr>



                                                        <tr>
                                                            <input type="hidden" value="<?php echo e($randomic = rand(11111, 99999)); ?>">

                                                            <form action="<?php echo e(route('empreendimentos.sms', $idEmp)); ?>" id="<?php echo e($randomic); ?>" method="POST"></form>
                                                            <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
                                                            <?php echo method_field('POST'); ?>

                                                            <td><strong>Proposta de compra gerada: </strong></td>
                                                            <td>
                                                                <select class="selectpicker" multiple="multiple" name="option[]" form="<?php echo e($randomic); ?>">
                                                                    <option value="5"> Administrador</option>
                                                                    <option value="7"> Corretor</option>
                                                                    <option value="6"> Imobiliaria</option>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <textarea class="editar" rows="2" cols="40" name="texto" maxlength="160" form="<?php echo e($randomic); ?>"></textarea>

                                                            </td>
                                                            <td>
                                                                <input type="checkbox" name="check" form="<?php echo e($randomic); ?>" data-toggle="toggle">
                                                            </td>
                                                            <td>
                                                                <input type="submit" form="<?php echo e($randomic); ?>" value="Salvar" name="salvar_terceiro" class="btn btn-primary">
                                                            </td>
                                                        </tr>


                                                        <tr>
                                                            <input type="hidden" value="<?php echo e($randomic = rand(11111, 99999)); ?>">

                                                            <form action="<?php echo e(route('empreendimentos.sms', $idEmp)); ?>" id="<?php echo e($randomic); ?>" method="POST"></form>
                                                            <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
                                                            <?php echo method_field('POST'); ?>

                                                            <td><strong>Contrato aprovado / reprovado: </strong></td>
                                                            <td>
                                                                <select class="selectpicker" multiple="multiple" name="option[]" form="<?php echo e($randomic); ?>">
                                                                    <option value="5"> Administrador</option>
                                                                    <option value="7"> Corretor</option>
                                                                    <option value="6"> Imobiliaria</option>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <textarea class="editar" rows="2" cols="40" name="texto" maxlength="160" form="<?php echo e($randomic); ?>"></textarea>

                                                            </td>
                                                            <td>
                                                                <input type="checkbox" name="check" form="<?php echo e($randomic); ?>" data-toggle="toggle">

                                                            </td>
                                                            <td>
                                                                <input type="submit" form="<?php echo e($randomic); ?>" value="Salvar" name="salvar_quarto" class="btn btn-primary">
                                                            </td>
                                                        </tr>


                                                        <tr>
                                                            <input type="hidden" value="<?php echo e($randomic = rand(11111, 99999)); ?>">

                                                            <form action="<?php echo e(route('empreendimentos.sms', $idEmp)); ?>" id="<?php echo e($randomic); ?>" method="POST"></form>
                                                            <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
                                                            <?php echo method_field('POST'); ?>

                                                            <td><strong>Ocorrências lançamento:</strong></td>
                                                            <td>
                                                                <select class="selectpicker" multiple="multiple" name="option[]" form="<?php echo e($randomic); ?>">
                                                                    <option value="5"> Administrador</option>
                                                                    <option value="7"> Corretor</option>
                                                                    <option value="6"> Imobiliaria</option>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <textarea class="editar" rows="2" cols="40" name="texto" maxlength="160" form="<?php echo e($randomic); ?>"></textarea>

                                                            </td>
                                                            <td>
                                                                <input type="checkbox" name="check" form="<?php echo e($randomic); ?>" data-toggle="toggle">

                                                            </td>
                                                            <td>
                                                                <input type="submit" form="<?php echo e($randomic); ?>" value="Salvar" name="salvar_quinta" class="btn btn-primary">
                                                            </td>
                                                        </tr>


                                                        <tr>
                                                            <input type="hidden" value="<?php echo e($randomic = rand(11111, 99999)); ?>">

                                                            <form action="<?php echo e(route('empreendimentos.sms', $idEmp)); ?>" id="<?php echo e($randomic); ?>" method="POST"></form>
                                                            <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
                                                            <?php echo method_field('POST'); ?>

                                                            <td><strong>Ocorrências tratativas: </strong></td>
                                                            <td>
                                                                <select class="selectpicker" multiple="multiple" name="option[]" form="<?php echo e($randomic); ?>">
                                                                    <option value="5"> Administrador</option>
                                                                    <option value="7"> Corretor</option>
                                                                    <option value="6"> Imobiliaria</option>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <textarea class="editar" rows="2" cols="40" name="texto" maxlength="160" form="<?php echo e($randomic); ?>"></textarea>

                                                            </td>
                                                            <td>
                                                                <input type="checkbox" name="check" form="<?php echo e($randomic); ?>" data-toggle="toggle">

                                                            </td>
                                                            <td>
                                                                <input type="submit" form="<?php echo e($randomic); ?>" value="Salvar" name="salvar_sexta" class="btn btn-primary">
                                                            </td>
                                                        </tr>


                                                        <tr>
                                                            <input type="hidden" value="<?php echo e($randomic = rand(11111, 99999)); ?>">

                                                            <form action="<?php echo e(route('empreendimentos.sms', $idEmp)); ?>" id="<?php echo e($randomic); ?>" method="POST"></form>
                                                            <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
                                                            <?php echo method_field('POST'); ?>

                                                            <td><strong>Aviso de vencimento de parcelas:</strong></td>
                                                            <td>
                                                                <select class="selectpicker" multiple="multiple" name="option[]" form="<?php echo e($randomic); ?>">
                                                                    <option value="8"> Cliente</option>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <textarea class="editar" rows="2" cols="40" name="texto" maxlength="160" form="<?php echo e($randomic); ?>"></textarea>

                                                            </td>
                                                            <td>
                                                                <input type="checkbox" name="check" form="<?php echo e($randomic); ?>" data-toggle="toggle">

                                                            </td>
                                                            <td>
                                                                <input type="submit" form="<?php echo e($randomic); ?>" value="Salvar" name="salvar_setima" class="btn btn-primary">
                                                            </td>
                                                        </tr>


                                                        <tr>
                                                            <input type="hidden" value="<?php echo e($randomic = rand(11111, 99999)); ?>">

                                                            <form action="<?php echo e(route('empreendimentos.sms', $idEmp)); ?>" id="<?php echo e($randomic); ?>" method="POST"></form>
                                                            <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
                                                            <?php echo method_field('POST'); ?>

                                                            <td><strong>Aviso de parcelas em atraso:</strong></td>
                                                            <td>
                                                                <select class="selectpicker" multiple="multiple" name="option[]" form="<?php echo e($randomic); ?>">
                                                                    <option value="8"> Cliente</option>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <textarea class="editar" rows="2" cols="40" name="texto" maxlength="160" form="<?php echo e($randomic); ?>"> </textarea>

                                                            </td>
                                                            <td>
                                                                <input type="checkbox" name="check" form="<?php echo e($randomic); ?>" data-toggle="toggle">

                                                            </td>
                                                            <td>
                                                                <input type="submit" form="<?php echo e($randomic); ?>" value="Salvar" name="salvar_oitava" class="btn btn-primary">
                                                            </td>
                                                        </tr>


                                                        <tr>
                                                            <input type="hidden" value="<?php echo e($randomic = rand(11111, 99999)); ?>">

                                                            <form action="routes_rotina_sms.php?idempreendimento=" id="<?php echo e($randomic); ?>" method="POST"></form>
                                                            <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
                                                            <?php echo method_field('POST'); ?>

                                                            <td><strong>Lançamento de contas a pagar:</strong></td>
                                                            <td>
                                                                <select class="selectpicker" multiple="multiple" name="option[]" form="<?php echo e($randomic); ?>">
                                                                    <option value="5"> Administrador</option>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <textarea class="editar" rows="2" cols="40" name="texto" maxlength="160" form="<?php echo e($randomic); ?>"></textarea>

                                                            </td>
                                                            <td>
                                                                <input type="checkbox" name="check" form="<?php echo e($randomic); ?>" data-toggle="toggle">

                                                            </td>
                                                            <td>
                                                                <input type="submit" form="<?php echo e($randomic); ?>" value="Salvar" name="salvar_nona" class="btn btn-primary">
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <input type="hidden" value="<?php echo e($randomic = rand(11111, 99999)); ?>">

                                                            <form action="<?php echo e(route('empreendimentos.sms', $idEmp)); ?>" id="<?php echo e($randomic); ?>" method="POST"></form>
                                                            <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
                                                            <?php echo method_field('POST'); ?>

                                                            <td><strong>Baixa de contas a pagar:</strong></td>
                                                            <td>
                                                                <select class="selectpicker" multiple="multiple" name="option[]" form="<?php echo e($randomic); ?>">
                                                                    <option value="5"> Administrador</option>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <textarea class="editar" rows="2" cols="40" name="texto" maxlength="160" form="<?php echo e($randomic); ?>"></textarea>

                                                            </td>
                                                            <td>
                                                                <input type="checkbox" name="check" form="<?php echo e($randomic); ?>" data-toggle="toggle">

                                                            </td>
                                                            <td>
                                                                <input type="submit" form="<?php echo e($randomic); ?>" value="Salvar" name="salvar_decima" class="btn btn-primary">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <input type="hidden" value="<?php echo e($randomic = rand(11111, 99999)); ?>">

                                                            <form action="<?php echo e(route('empreendimentos.sms', $idEmp)); ?>" id="<?php echo e($randomic); ?>" method="POST"></form>
                                                            <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
                                                            <?php echo method_field('POST'); ?>

                                                            <td><strong>Baixa de Contas a Receber:</strong></td>
                                                            <td>
                                                                <select class="selectpicker" multiple="multiple" name="option[]" form="<?php echo e($randomic); ?>">
                                                                    <option value="5"> Administrador</option>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <textarea class="editar" rows="2" cols="40" name="texto" maxlength="160" form="<?php echo e($randomic); ?>"></textarea>

                                                            </td>
                                                            <td>
                                                                <input type="checkbox" name="check" form="<?php echo e($randomic); ?>" data-toggle="toggle">

                                                            </td>
                                                            <td>
                                                                <input type="submit" form="<?php echo e($randomic); ?>" value="Salvar" name="salvar_decima1" class="btn btn-primary">
                                                            </td>
                                                        </tr>


                                                        <tr>
                                                            <input type="hidden" value="<?php echo e($randomic = rand(11111, 99999)); ?>">

                                                            <form action="<?php echo e(route('empreendimentos.sms', $idEmp)); ?>" id="<?php echo e($randomic); ?>" method="POST"></form>
                                                            <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
                                                            <?php echo method_field('POST'); ?>

                                                            <td><strong>Simulação de venda gerada:</strong></td>
                                                            <td>
                                                                <select class="selectpicker" multiple="multiple" name="option[]" form="<?php echo e($randomic); ?>">
                                                                    <option value="5"> Administrador</option>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <textarea class="editar" rows="2" cols="40" name="texto" maxlength="160" form="<?php echo e($randomic); ?>"></textarea>

                                                            </td>
                                                            <td>
                                                                <input type="checkbox" name="check" form="<?php echo e($randomic); ?>" data-toggle="toggle">

                                                            </td>
                                                            <td>
                                                                <input type="submit" form="<?php echo e($randomic); ?>" value="Salvar" name="salvar_decima2" class="btn btn-primary">
                                                            </td>
                                                        </tr>

                                                    </tbody>
                                                </table>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="default-tab-12">
                            <div class="row">
                                <div class="panel-body">
                                    <h3 class="m-t-10"><i class="fa fa-trash" aria-hidden="true"></i>&nbsp;Deletar Gestão</h3>
                                    <hr>
                                    <br><i class="fa fa-exclamation-triangle" aria-hidden="true"></i>
                                   <label for="">Deseja deletar esta gestão? (Esta ação não poderá ser desfeita)</label>
                                    <br><br>
                                    <div class="text-right">
                                        <a class="delete" id="<?php echo e($idEmp); ?>"><span class="btn btn-danger">Deletar</span></a>

                                    </div>
                                </div>
                            </div>
                        </div>



                        <!-- Modal Deletar Gestão  -->
                        <div class="modal fade" id="modal_excluir" role="dialog">
                            <div class="modal-dialog modal-xs">

                                <div class="modal-content">


                                    <style>
                                        .excluir {
                                            background-color: #BD0900;
                                            margin-top: -30px;
                                        }

                                        .excluir_mod {
                                            color: white;
                                            font-weight: bold;
                                        }

                                        .excluir_mod:hover {
                                            color: black;
                                            font-weight: bold;
                                        }

                                        .text-center {
                                            background-color: #BD0900;
                                            color: white;
                                            padding: 15px;
                                            box-sizing: border-box;
                                            border-radius: 4px;
                                        }

                                        .pull-left {
                                            font-size: 16px;
                                        }
                                    </style>

                                    <div class="modal-body">
                                        <legend class="text-center block2">Excluir Gestão </legend>



                                        <div style="margin-bottom: 0px;" class="tab-content">

                                            <div id="excluir" class="tab-pane fade in active">
                                                <form method="POST" class="form-del" id="delete_form_modal">

                                                    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
                                                    <fieldset>
                                                        <legend class="pull-left width-full">Você está prestes a excluir esta gestão, deseja prosseguir? </legend>
                                                        <!-- <legend  class="pull-left width-full">Deseja realmente excluir o cadastro selecionado? </legend> -->
                                                    </fieldset>


                                                    <div class="text-right block3">
                                                        <button type="button" class="btn btn-danger" name="deleteModal" id="deleteModal">Sim, desejo excluir!</button>
                                                        <button type="button" class="btn btn-secondary" name="del" id="del" data-toggle="modal" data-target="#modal_excluir">Cancelar</button>
                                                        <!-- <input type="submit" name="deleteModal" id="deleteModal" value="Sim, desejo excluir!" class="btn btn-danger"> -->

                                                    </div>

                                                </form>
                                            </div>



                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                </div>
            </div>
            <!-- end row -->
        </div>
        <!-- end #content -->

        <!-- begin scroll to top btn -->
        <a href="javascript:;" class="btn btn-icon btn-circle btn-success btn-scroll-to-top fade" data-click="scroll-top"><i class="fa fa-angle-up"></i></a>
        <!-- end scroll to top btn -->
    </div>
    <!-- end page container -->

    <div class="modal fade" id="detalhe_equipe" role="dialog">
        <div class="modal-dialog modal-lg" style="background: white;">
            <div class="panel-heading" style="background: black">
                <spam style="color: white">Detalhes Da equipe</spam>
            </div>
            <div style="height: auto ; background: white; padding: 40px">
                <table class="table-reponsive">
                    <tr>
                        <td style="width: 100%"><strong style="font-size: 15px; ">Dados Detalhado Da Equipe:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <br><br> </strong>
                            <strongs style="font-size: 15px; font-weight: bold;text-decoration:  underline; ">
                                <div id="nom_equipe"></div></strong>
                        </td>
                    </tr>
                    <tr>
                        <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<br></td>
                    </tr>
                    <tr>
                        <td>
                            <div id="result_equipe1"></div>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.9/dist/js/bootstrap-select.min.js"></script>
    <script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>

    <script src="https://immobilebusiness.com.br/admin/assets/plugins/jquery/jquery-1.9.1.min.js"></script>
    <script src="https://immobilebusiness.com.br/admin/assets/js/jquery.maskMoney.js" type="text/javascript"></script>
    <script src="https://immobilebusiness.com.br/admin/assets/plugins/jquery/jquery-migrate-1.1.0.min.js"></script>
    <script src="https://immobilebusiness.com.br/admin/assets/plugins/jquery-ui/ui/minified/jquery-ui.min.js"></script>
    <script src="https://immobilebusiness.com.br/admin/assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <script src="https://immobilebusiness.com.br/admin/assets/plugins/slimscroll/jquery.slimscroll.min.js"></script>
    <script src="https://immobilebusiness.com.br/admin/assets/plugins/jquery-cookie/jquery.cookie.js"></script>
    <!--[if lt IE 9]>
    <script src="https://immobilebusiness.com.br/admin/assets/crossbrowserjs/html5shiv.js"></script>
    <script src="https://immobilebusiness.com.br/admin/assets/crossbrowserjs/respond.min.js"></script>
    <script src="https://immobilebusiness.com.br/admin/assets/crossbrowserjs/excanvas.min.js"></script>
    <![endif]-->

    <!-- ================== END BASE JS ================== -->
    <script src="https://immobilebusiness.com.br/admin/assets/plugins/select2/dist/js/select2.min.js"></script>
    <script src="https://immobilebusiness.com.br/admin/assets/js/form-plugins.demo.min.js"></script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>


    <!-- ================== BEGIN PAGE LEVEL JS ================== -->
    <script src="https://immobilebusiness.com.br/admin/assets/js/apps.min.js"></script>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.9/dist/css/bootstrap-select.min.css">
    <link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet">



    <script>
        var user_id;
        $(document).on('click', '.delete', function() {
            user_id = $(this).attr('id');
            $('#modal_excluir').modal('show');
        });
        $('#deleteModal').click(function() {
            $.ajax({
                url: "/gestao/delete/ " + user_id,
                type: 'POST',

                beforeSend: function() {
                    $('#deleteModal').text('Deletando...');
                },
                success: function(data) {
                    setTimeout(function() {
                        $('#modal_excluir').modal('show');
                        // $('#user_table').DataTable().ajax.reload();
                        window.location.href = "/gestao_vendas";

                    });
                    // swal("Sucesso","Gestão deletada com successo!", "success");
                }
            });
        });

    </script>




    <script>
        $(document).ready(function() {
            App.init();
            TableManageButtons.init();
            FormPlugins.init();
        });
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
    </script>
    <script type="text/javascript">
        $(function() {


            $("#desconto_empreendimento").maskMoney({
                symbol: '',
                showSymbol: true,
                thousands: '.',
                decimal: '.',
                symbolStay: true
            });


            $("#percentual_entrada").maskMoney({
                symbol: '',
                showSymbol: true,
                thousands: '.',
                decimal: '.',
                symbolStay: true
            });

            $("#parcelamento_entrada").maskMoney({
                symbol: '',
                showSymbol: true,
                thousands: '.',
                decimal: '.',
                symbolStay: true
            });

            $("#comissao_imob_empreendimento").maskMoney({
                symbol: '',
                showSymbol: true,
                thousands: '.',
                decimal: '.',
                symbolStay: true
            });

            $("#dias_repasse").maskMoney({
                symbol: '',
                showSymbol: true,
                thousands: '.',
                decimal: '.',
                symbolStay: true
            });




        })
    </script>

    <script>
        function chama_detalhe(equipe) {

            var id = document.getElementById('pega_imob');

            $.ajax({
                url: '/mostra_detalhe_equipe/' + id,
                /* URL que será chamada */
                type: 'GET',
                /* Tipo da requisição */
                data: 'equipe=' + equipe,
                /* dado que será enviado via POST */
                dataType: 'json',
                /* Tipo de transmissão */
                success: function(data) {

                    $("#nom_equipe").html(data.nome_equipe);

                    let $requipe = $('#result_equipe1');

                    $requipe.html('');

                    $.each(data.dados, function(index, idlote, lote) {

                        $requipe.append("<div class='col-md-12'><label><strong>'" + idlote + "</strong>' </label><input placeholder='% Comissao' class='form-control corret' id='c" + index + "'  type='text' name='" + idlote + "' value='" + data.percentual[index] + " - %' readonly></div><br></div>");
                    });

                }

            });

        }

        $(document).on('blur', '#repasse_equipe', function() {
            alert("jquery funcionando");

        })

        $(document).ready(function() {

            $('#equipe_venda').change(function() {

                /* Busca os membros da equipe selecionada */
                $.ajax({
                    url: '/buscaequipe',
                    /* URL que será chamada */
                    type: 'GET',
                    /* Tipo da requisição */
                    data: 'equipe=' + $('#equipe_venda').val(),
                    /* dado que será enviado via POST */
                    dataType: 'json',
                    /* Tipo de transmissão */
                    success: function(data) {

                        var $result_equipe = $('#result_equipe');
                        $result_equipe.html('');

                        $.each(data, function(idlote, lote) {
                            $result_equipe.append("<label>'" + lote + "' </label><input placeholder='% Comissao' class='form-control maskk'   type='text' name='" + idlote + "'> <br>");

                        });

                        $result_equipe.change();

                    }
                    //     return false;    
                });
            });

            $(document).on("focus", ".maskk", function() {

                $(this).maskMoney({
                    symbol: '',
                    showSymbol: true,
                    thousands: '.',
                    decimal: '.',
                    symbolStay: true
                })
            });

            //   percentuais para correção

            var $entrada_antiga = $("#taxa_entrada").val();
            $("#coloca_entrada_aqui").html("<input type='hidden' name='taxa_entrada_old' id='taxa_entrada' value='" + $entrada_antiga + "' class='form-control'>");

            var $taxa_antiga = $("#taxa_financiamento").val();
            $("#coloca_saldo_aqui").html("<input type='hidden' name='taxa_financiamento_old' id='taxa_financiamento' value='" + $taxa_antiga + "' class='form-control'>");

            //  percentual dados sobre comissão
            var $percentual_antigo = $("#percentual_gestao").val();
            $("#coloca_percentual_aqui").html("<input type='hidden' name='percentual_gestao_old' id='percentual_gestao' value='" + $percentual_antigo + "' class='form-control'>");

            var $percentual_midia_antigo = $("#percentual_midia").val();
            $("#coloca_percentual_midia_aqui").html("<input type='hidden' name='percentual_midia_old' id='percentual_midia' value='" + $percentual_midia_antigo + "' class='form-control'>");

            App.init();

        });
    </script>

    <script type="text/javascript">
        var senha = $('#senha1');
        var olho = $("#olho1");

        olho.mousedown(function() {
            senha.attr("type", "text");
        });

        olho.mouseup(function() {
            senha.attr("type", "password");
        });
        // para evitar o problema de arrastar a imagem e a senha continuar exposta, 
        //citada pelo nosso amigo nos comentários
        $("#olho1").mouseout(function() {
            $("#senha1").attr("type", "password");
        });
    </script>

    <script type="text/javascript">
        var senha1 = $('#senha2');
        var olho1 = $("#olho2");

        olho1.mousedown(function() {
            senha1.attr("type", "text");
        });

        olho1.mouseup(function() {
            senha1.attr("type", "password");
        });
        // para evitar o problema de arrastar a imagem e a senha continuar exposta, 
        //citada pelo nosso amigo nos comentários
        $("#olho2").mouseout(function() {
            $("#senha2").attr("type", "password");
        });
    </script>

    <script type="text/javascript">
        //EFEITOS PARA APLICAR MASCARA DE DINHEIRO 
        $(document).on('blur', '#dinheiro', function() {

            let aux = $(this).val();

            aux = parseFloat(aux.replace(/[R$. ]/g, '').replace(/,/g, '.'));

            isNaN(aux) ? aux = 0 : '';

            aux = aux.toLocaleString('pt-br', {
                style: 'currency',
                currency: 'BRL'
            });

            // console.log(aux);
            $(this).val(aux);
        });

        //EFEITOS PARA APLICAR MASCARA DE DINHEIRO
        $(document).on('focus', '#dinheiro', function() {
            $(this).val('');
        });
    </script>

    <script type="text/javascript">
        //EFEITOS PARA APLICAR MASCARA DE DINHEIRO 
        $(document).on('blur', '#dinheiro2', function() {

            let aux = $(this).val();

            aux = parseFloat(aux.replace(/[R$. ]/g, '').replace(/,/g, '.'));

            isNaN(aux) ? aux = 0 : '';

            aux = aux.toLocaleString('pt-br', {
                style: 'currency',
                currency: 'BRL'
            });

            // console.log(aux);
            $(this).val(aux);
        });

        //EFEITOS PARA APLICAR MASCARA DE DINHEIRO
        $(document).on('focus', '#dinheiro2', function() {
            $(this).val('');
        });
    </script>

    <script type="text/javascript">
        var chec = document.getElementById('riksore');
        var chec1 = document.getElementById('falter');
        var chec2 = document.getElementById('aprova');

        $("#riksore").click(function() {
            if (chec.checked) {
                swal("Atenção!",
                    "Com o Consulta RiskSore selecionado será cobrado uma taxa de R$10,00 Reais a mais por consulta.",
                    "warning")
            }
        });

        $("#aprova").click(function() {
            if (chec2.checked) {
                swal("Atenção!",
                    "Com o aprova automatico selecionado, seus contratos seram aprovados automatico.",
                    "warning")
            }
        });

        $("#falter").click(function() {
            if (chec1.checked) {
                swal("Atenção!", "Este campo deve ficar desmarcado se você pretende não fazer a consulta.",
                    "warning")
            }
        });
    </script>

    <script>
        console.log($('#falter').attr('checked') == "checked");
        if ($('#falter').attr('checked') == "checked") {
            $(".aparece").each(function(index, element) {
                element.removeAttribute("disabled");
            });
        }
    </script>

    <script type="text/javascript">
        var chec1 = document.getElementById('falter');
        $(document).on("change", "#falter", function() {
            if (chec1.checked) {
                $(".aparece").each(function(index, element) {
                    element.removeAttribute("disabled");
                });

            } else {

                $(".aparece").each(function(index, element) {
                    element.setAttribute("disabled", "true");

                });
            }
        });
    </script>
</body>


</html><?php /**PATH C:\xampp\htdocs\light\resources\views/empreendimentos/configuracoes/configuracoes_emp.blade.php ENDPATH**/ ?>