<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');

//Route::get('/clientes', 'ClienteController@index');
Route::any('pesquisar','ClienteController@pesquisar');

Route::resource('clientes','ClienteController');

Route::post('/clientes/destroy/{id}','ClienteController@destroy');

Route::get('/cadastro_cliente','CadastroClienteController@cadastro');

Route::post('/cadastro_cliente','CadastroClienteController@cadastrar');

Route::post('/cad_telefone','CadastroClienteController@cadTelefone');

Route::post('/consultar_cep','CadastroClienteController@recebeCep');

Route::post('/recebeEnderecoModal','CadastroClienteController@recebeEndereco');

Route::post('/cadastraEnderecoModal','CadastroClienteController@recebeEndereco');

Route::post('/cadastroConjuge','CadastroClienteController@cadConjuge');

Route::post('/consultar_cpf','CadastroClienteController@consultaCpf');

Route::post('/clientes/{id}','ClienteController@update');

Route::post('/atualizaEndereco','ClienteController@atualizaEndereco');

Route::post('/atualizaTelefone','ClienteController@atualizaTelefone');

Route::post('/historico_cliente/{id}','ClienteController@historico');


//////////EMPREENDIMENTO
Route::resource('empreendimentos','EmpreendimentoController');

Route::get('/cadastro_empreendimento','EmpreendimentoController@CadastroEmpreendimento');

Route::post('/cadastrar_empreendimento','EmpreendimentoController@CadastrarEmpre');

Route::post('/gestao/delete/{id}','EmpreendimentoController@deleteGestao');

// Route::post('/alterar_empreendimento','EmpreendimentoController@Alterar');

Route::post('/empreendimentos/destroy/{id}','EmpreendimentoController@destroy');

Route::post('/empreendimentos/{id}','EmpreendimentoController@update');

Route::get('/mapa_empreendimento/{id}','EmpreendimentoController@mapa');

Route::post('mapa/{id}','EmpreendimentoController@cadastrarMapa')->name('mapa');

Route::get('/anexo_empreendimento/{id}','EmpreendimentoController@anexo');

Route::post('anexo/{id}','EmpreendimentoController@cadastrarAnexo')->name('anexo');

Route::post('/anexos/delete/{id}','EmpreendimentoController@deleteAnexo');

Route::get('/logomarca/{id}','EmpreendimentoController@logomarca');

Route::post('fotos_emp/{id}','EmpreendimentoController@cadastrarFotos')->name('fotos_emp');

Route::post('/fotos/delete/{id}','EmpreendimentoController@deleteFotos');

Route::post('/marcarimagem/{id}','EmpreendimentoController@definePrincipal');

Route::get('/gestao_vendas','EmpreendimentoController@gestao')->name('lista_gestao');

Route::get('/configuracoes_empreendimentos/{id}','EmpreendimentoController@configuracoes');

Route::get('/cadastro_gestao','EmpreendimentoController@CadastroGestao');

Route::post('/cadastrar_gestao','EmpreendimentoController@CadastrarGestao');

Route::get('/conta_corrente','ConfiguracoesController@ContaCorrente'); ////// Conta Corrente Cliente

Route::get('/cadastrar_conta','ConfiguracoesController@CadastrarConta'); ////// Conta Corrente Cliente

Route::post('/criar_conta_corrente','ConfiguracoesController@CriaConta'); ////// Conta Corrente Cliente

Route::get('/editar_conta/{id}','ConfiguracoesController@Editar'); ////// Conta Corrente Cliente

Route::post('/atualizar_conta_corrente/{id}','ConfiguracoesController@atualizarConta'); ////// Conta Corrente Cliente

Route::post('/contacorrente/delete/{id}','ConfiguracoesController@deletaConta'); ////// Conta Corrente Cliente


/////////////////////////////////////////CONFIGURAÇÕES EMPREENDIMENTO////////////////////////////////////////////////////
Route::post('/desconto_empre/{id}','EmpreendimentoController@descontos');

Route::post('/parcelamento/{id}','EmpreendimentoController@parcelamento');

Route::post('/minimo/{id}','EmpreendimentoController@minimo');

Route::post('/plano_pagamento/{id}','EmpreendimentoController@plano');

Route::post('/correcao_entrada/{id}','EmpreendimentoController@correcao');

Route::post('/centro_receitas/{id}','EmpreendimentoController@centroCusto');

Route::post('/distrato/{id}','EmpreendimentoController@distrato');

Route::post('/serasa/{id}','EmpreendimentoController@serasa');

Route::post('/scpc/{id}','EmpreendimentoController@scpc');

Route::post('/percentual_comissao_geral/{id}','EmpreendimentoController@percentualComissao');

Route::post('/equipe_empreendimento/{id}','EmpreendimentoController@cadastroEquipe');

Route::post('/repasse/{id}','EmpreendimentoController@repasseEquipe');

Route::get('/buscaequipe','EmpreendimentoController@buscarEquipe');

Route::get('/mostra_detalhe_equipe/{id}','EmpreendimentoController@mostraDetalheEquipe');


////////// ROTA SMS ///////////
Route::post('/route_sms/{id}','EmpreendimentoController@atualizaSms')->name('empreendimentos.sms');


/////////// DELETES //////////
Route::delete('/delete_parcelamento/{id}','EmpreendimentoController@deleteParcelamento');

Route::delete('/delete_desconto/{id}','EmpreendimentoController@deleteDesconto');

Route::delete('/delete_comissao/{id}','EmpreendimentoController@deleteComissao');

Route::delete('/delete_equipe/{id}','EmpreendimentoController@deleteEquipe');

Route::delete('/delete_distrato/{id}','EmpreendimentoController@deleteDistrato');

Route::delete('/delete_repasse/{id}','EmpreendimentoController@deleteRepasse');

///////////////////////////////////////IMPRIMIR LOTE DE EMPREENDIMENTO////////////////////////////////////////////////////
Route::get('/imprimir_lotes/{id}','EmpreendimentoController@indexLote');

Route::get('/relatorio_vendas/{id}','RelatorioEmpController@index');

Route::get('/cadastrar_quadra/{id}','RelatorioEmpController@CadastrarQuadra');

Route::post('/cadastro_quadra/{id}','RelatorioEmpController@CadastroQuadra');