<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

class ConfiguracoesController extends Controller
{
    public function ContaCorrente(Request $request)
    {
        $user_id = Auth::user()->id;
        $listaContas = DB::select("SELECT * FROM contacorrente WHERE conta_id =  $user_id");
        return view('configuracoes.conta_corrente', compact('listaContas'));
    }

    public function CadastrarConta(Request $request)
    {
        $user_id = Auth::user()->id;

        $empreendimentos = DB::select("SELECT * FROM cliente
        INNER JOIN cliente_tipo ON cliente.idcliente = cliente_tipo.idcliente 
        INNER JOIN tipo_cliente ON cliente_tipo.idtipo = tipo_cliente.idtipo 
        where cliente_tipo.idtipo = 12 AND conta_id = $user_id  order by nome_cli Asc");

        return view('configuracoes.cadastrar_conta', compact('empreendimentos'));
    }

    public function CriaConta(Request $request)
    {
        date_default_timezone_set('America/Sao_Paulo');

        $data_cadastro      = date('Y-m-d H:i:s');
        $cadastrado_por = $request->get('cadastrado_por');
        $nome_cedente        = $request->get("nome_cedente");
        $agencia            = $request->get("agencia");
        $dig_agencia        = $request->get("dig_agencia");
        $carteira           = $request->get("carteira");
        $conta              = $request->get("conta");
        $dig_conta          = $request->get("dig_conta");
        $cpf                = $request->get("cpf");
        $codigo_cedente     = $request->get("codigo_cedente");
        $cod_beneficiario   = $request->get("cod_beneficiario");
        $cod_transmissao    = $request->get("cod_transmissao");
        $nome_empresa       = $request->get("nome_empresa");
        $banco_cedente      = $request->get("banco");
        $data_abertura      = $request->get("data_abertura");
        $cliente_idcliente  = $request->get("cliente_idcliente");
        $posto              = $request->get("posto");
        $quem_envia         = $request->get("quem_envia");
        $dias_baixa_banco   = $request->get("dias_baixa_banco");
        $chave_master       = $request->get('chave_master');
        $descricao_conta    = $request->get('descricao_conta');
        $data_abertura      = date("d-m-Y", strtotime($data_abertura));

        if ($banco_cedente == 001) {
            $nome_banco = 'Bando do Brasil (240)';
        } elseif ($banco_cedente == 237) {
            $nome_banco = 'Bradesco (240)';
        } elseif ($banco_cedente == 104) {
            $nome_banco = 'Caixa (240)';
        } elseif ($banco_cedente == '033') {
            $nome_banco = 'Santander (240)';
        } elseif ($banco_cedente == 756) {
            $nome_banco = 'Sicoob (240)';
        } elseif ($banco_cedente == 748) {
            $nome_banco = 'Sicredi (240)';
        }

        // dd($nome_banco);
        $cadastrarConta = DB::insert("INSERT INTO contacorrente (descricao_conta,nome_cedente, agencia, dig_agencia, conta, dig_conta, carteira, cpf, codigo_cedente, nome_empresa, banco, nome_banco, cod_beneficiario, cod_transmissao, cadastrado_por, data_cadastro, data_abertura, cliente_idcliente, posto, quem_envia, dias_baixa_banco, chave_master,conta_id) 
        values ('$descricao_conta','$nome_cedente','$agencia','$dig_agencia', '$conta', '$dig_conta', '$carteira','$cpf', '$codigo_cedente','$nome_empresa','$banco_cedente','$nome_banco','$cod_beneficiario','$cod_transmissao', '$cadastrado_por', '$data_cadastro','$data_abertura', '$cliente_idcliente', '$posto', '$quem_envia', '$dias_baixa_banco', '$chave_master','$cadastrado_por')");

        if ($cadastrarConta) {
            return redirect('conta_corrente')->with('success', 'Conta cadastrada com sucesso!');
        } else {
            return redirect()->back()->with('error', 'Ocorreu um erro ao cadastrar sua conta, verifique os dados e tente novamente!');
        }
    }


    public function Editar(Request $request, $id)
    {
        $user_id = Auth::user()->id;

        $empreendimentos = DB::select("SELECT * FROM cliente
        INNER JOIN cliente_tipo ON cliente.idcliente = cliente_tipo.idcliente 
        INNER JOIN tipo_cliente ON cliente_tipo.idtipo = tipo_cliente.idtipo 
        where cliente_tipo.idtipo = 12 AND conta_id = $user_id  order by nome_cli Asc");
        $selConta = DB::select("SELECT * FROM contacorrente  WHERE conta_id = $user_id AND idcontacorrente = $id");
        $listaContas = DB::select("SELECT * FROM contacorrente WHERE conta_id =  $user_id AND idcontacorrente = $id");

        return view('configuracoes.alterar_conta', compact('empreendimentos', 'selConta', 'listaContas'));
    }

    public function atualizarConta(Request $request, $id)
    {

        date_default_timezone_set('America/Sao_Paulo');

        $data_cadastro      = date('Y-m-d H:i:s');
        $cadastrado_por = $request->get('cadastrado_por');
        $nome_cedente        = $request->get("nome_cedente");
        $agencia            = $request->get("agencia");
        $dig_agencia        = $request->get("dig_agencia");
        $carteira           = $request->get("carteira");
        $conta              = $request->get("conta");
        $dig_conta          = $request->get("dig_conta");
        $cpf                = $request->get("cpf");
        $codigo_cedente     = $request->get("codigo_cedente");
        $cod_beneficiario   = $request->get("cod_beneficiario");
        $cod_transmissao    = $request->get("cod_transmissao");
        $nome_empresa       = $request->get("nome_empresa");
        $banco_cedente      = $request->get("banco");
        $data_abertura      = $request->get("data_abertura");
        $cliente_idcliente  = $request->get("cliente_idcliente");
        $posto              = $request->get("posto");
        $quem_envia         = $request->get("quem_envia");
        $dias_baixa_banco   = $request->get("dias_baixa_banco");
        $chave_master       = $request->get('chave_master');
        $descricao_conta    = $request->get('descricao_conta');
        $data_abertura      = date("d-m-Y", strtotime($data_abertura));

        if ($banco_cedente == 001) {
            $nome_banco = 'Bando do Brasil (240)';
        } elseif ($banco_cedente == 237) {
            $nome_banco = 'Bradesco (240)';
        } elseif ($banco_cedente == 104) {
            $nome_banco = 'Caixa (240)';
        } elseif ($banco_cedente == '033') {
            $nome_banco = 'Santander (240)';
        } elseif ($banco_cedente == 756) {
            $nome_banco = 'Sicoob (240)';
        } elseif ($banco_cedente == 748) {
            $nome_banco = 'Sicredi (240)';
        }

        $updateConta = DB::update("UPDATE contacorrente SET descricao_conta = '$descricao_conta', cliente_idcliente = '$cliente_idcliente', agencia = '$agencia', dig_agencia = '$dig_agencia', 
        conta = '$conta', dig_conta = '$dig_conta', carteira = '$carteira', cpf = '$cpf', codigo_cedente = '$codigo_cedente', nome_empresa = '$nome_empresa', banco = '$banco_cedente', nome_banco = '$nome_banco', cod_beneficiario = '$cod_beneficiario', cod_transmissao = '$cod_transmissao', cadastrado_por = '$cadastrado_por', data_cadastro = '$data_cadastro', 
        data_abertura = '$data_abertura', cliente_idcliente = '$cliente_idcliente', posto = '$posto', quem_envia = '$quem_envia', dias_baixa_banco = '$dias_baixa_banco', chave_master = '$chave_master' WHERE idcontacorrente  =  $id ");


        if ($updateConta) {
            return redirect('conta_corrente')->with('success', 'Conta atualizada com sucesso!');
        } else {

            return redirect()->back()->with('error', 'Erro ao atualizar dados da conta, verifique os campos e tente novamente!');
        }
    }
    public function deletaConta(Request $request, $id)
    {
        $delContaCorrente = DB::delete("DELETE FROM contacorrente where idcontacorrente =  $id");
        return response()->json(['success' => $delContaCorrente]);

        if ($delContaCorrente) {
            return redirect('conta_corrente')->with('success', 'Conta deletada com sucesso!');
        } else {

            return redirect()->back()->with('error', 'Ocorreu um erro ao deletar a conta, tente novamente mais tarde!');
        }
    }
}
