<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ClienteModel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

use App\TipoClienteModel;
use App\grupoModel;
use App\GrupoClienteModel;



class ClienteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */


    public function __construct(clienteModel $clienteModel)
    {
        $this->middleware('auth');
        $this->clienteModel = $clienteModel;
    }
    ///////////////////////////////////////////////////Pesquisar Clientes//////////////////////////////////////////////////////////

    public function Pesquisar(Request $request)
    {
        $id = Auth::user()->id;

        $corretor = DB::select("SELECT cliente.nome_cli, cliente.idcliente FROM cliente
        INNER JOIN cliente_tipo ON cliente.idcliente = cliente_tipo.idcliente
         where idtipo = 8 AND conta_id = $id group by cliente.idcliente order by nome_cli ASC");
        $imobiliaria = DB::select("SELECT cliente.nome_cli, cliente.idcliente FROM cliente
        INNER JOIN cliente_tipo ON cliente.idcliente = cliente_tipo.idcliente
         where idtipo = 11 AND conta_id = $id group by cliente.idcliente order by nome_cli ASC");
        $nome_cliente        = $request->get('nome_cliente');
        $cpf_cliente         = $request->get('cpf_cliente');
        $codigo_cliente      = $request->get('codigo_cliente');
        $imobiliaria_cliente = $request->get('imobiliaria_id');
        $corretor_id         = $request->get('corretor_id');

        $where = 'cliente.idcliente > 0';

        if ($nome_cliente != '') {
            $where .= " AND nome_cli LIKE '%" . $nome_cliente . "%'";
        }

        if ($cpf_cliente != '') {
            $where .= " AND cpf_cli LIKE '%" .  $cpf_cliente . "%'";
        }

        if ($codigo_cliente != '') {
            $where .= " AND cliente.idcliente =" . $codigo_cliente;
        }

        if ($corretor_id != '') {
            $where .= " AND cliente.idcliente =" . $corretor_id;
        }

        if ($imobiliaria_cliente != '') {
            $where .= " AND cliente.idcliente =" . $imobiliaria_cliente;
        }



        $clientes = DB::select("SELECT * FROM cliente WHERE conta_id = $id and $where ", [1]);

        // ->orWhere('cpf_cli','like','%'.$cpf_cliente.'%')
        // ->orWhere('idcliente','=','$codigo_cliente')
        // ->orWhere('imob_id','=','$imobiliaria_cliente')

        //  ->orderBy('nome_cli');
        return view('cliente.clientes', ['clientes' => $clientes], compact('imobiliaria','corretor'));
    }

    ///////////////////////////////////////////////////View Cliente//////////////////////////////////////////////////////////

    public function index(clienteModel $clienteModel, TipoClienteModel $tipoClienteModel)
    {
        $id = Auth::user()->id;
        $tipoCliente =  DB::select("SELECT * FROM cliente_tipo where idcliente_tipo = $id");
        $corretor = DB::select("SELECT cliente.nome_cli, cliente.idcliente FROM cliente
        INNER JOIN cliente_tipo ON cliente.idcliente = cliente_tipo.idcliente
         where idtipo = 8 AND conta_id = $id group by cliente.idcliente order by nome_cli ASC");
        $imobiliaria = DB::select("SELECT cliente.nome_cli, cliente.idcliente FROM cliente
        INNER JOIN cliente_tipo ON cliente.idcliente = cliente_tipo.idcliente
         where idtipo = 11 AND conta_id = $id group by cliente.idcliente order by nome_cli ASC");
        $clientes = DB::select("SELECT * FROM cliente where conta_id = $id");
        return view('cliente/clientes', compact('clientes', 'tipoCliente', 'imobiliaria','corretor'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    ///////////////////////////////////////////////////Editar Cliente//////////////////////////////////////////////////////////

    public function edit(
        Request $request,
        $id,
        GrupoModel $grupoModel,
        ClienteModel $clienteModel,
        GrupoClienteModel $grupoClienteModel,
        TipoClienteModel $tipoClienteModel
    ) {
        $checked = DB::select("SELECT * FROM tipo_cliente ORDER BY idtipo DESC");


        // function verifica_tipo_user($id, $idtipo)
        // {
        //     $check2 = DB::select("SELECT * FROM cliente_tipo
        //     WHERE idcliente = $id AND idtipo = $idtipo");
        //     foreach ($check2 as $checkId) {
        //         $idcliente_tipo = $checkId->idcliente_tipo;
        //         $tipoCheck = $checkId->idtipo;
        //         $array2[] = array('idcliente_tipo' => $idcliente_tipo, 'idtipo'=>$tipoCheck);
        //         return $array2;
        //     }

        //     // return $idcliente_tipo;
        // }
        // foreach ($checked as $check) {



        //     $descricao_tipo      = $check->descricao_tipo;
        //     $idtipo              = $check->idtipo;

        //     $array[] = array('descricao_tipo' => $descricao_tipo, 'idtipo' => $idtipo);

        //     $verifica = verifica_tipo_user($id, $idtipo);

        //     // dd($verifica);

        // }
        $veri = DB::select("SELECT * FROM cliente_tipo where idcliente = $id ", [1]);

        foreach ($veri as $ver) {
            $idtipoCli = $ver->idtipo;
            $idcliente = $ver->idcliente;

            $array[] =  array('idtipo' => $idtipoCli, 'idcliente' => $idcliente);
        }

        $tipoCliente =  DB::select("SELECT * FROM tipo_cliente ORDER BY descricao_tipo");
        $grupo = $grupoModel->all();
        $grupoCad = DB::select("SELECT grupo.titulo_grupo FROM grupo INNER JOIN cliente on cliente.idgrupo = grupo.idgrupo WHERE cliente.idcliente =  $id");
        $scoreCad = DB::select("SELECT grupo_cliente.descricao FROM grupo_cliente INNER JOIN cliente on cliente.categoria_cliente = grupo_cliente.idgrupo_cliente WHERE cliente.idcliente =  $id");
        $grupoCliente = $grupoClienteModel->all();
        $clienteConj = DB::select("SELECT cliente.nome_cli, cliente.idcliente FROM cliente
        INNER JOIN cliente_tipo ON cliente.idcliente = cliente_tipo.idcliente
         where idtipo = 6 group by cliente.idcliente order by nome_cli ASC");
        $enderecoCli = DB::select("SELECT * FROM endereco_cli where id_cliente =  $id", [1]);
        $clientes = DB::select("SELECT * FROM cliente WHERE idcliente = $id ", [1]);
        $telefoneCli  = DB::select("SELECT * FROM telefone_cli where id_cliente = $id", [1]);
        $username =  Auth::user()->name;
        $imob =  DB::select("SELECT * FROM cliente
        INNER JOIN cliente_tipo ON cliente.idcliente = cliente_tipo.idcliente 
        where cliente_tipo.idtipo = 11  order by nome_cli Asc");

        return view('cliente.alterar', ['clientes' => $clientes, 'enderecoCli' => $enderecoCli, 'telefoneCli' => $telefoneCli], compact('grupo', 'imob', 'checked', 'id', 'grupoCad', 'enderecoCli', 'scoreCad', 'clienteConj', 'grupoCliente', 'tipoCliente', 'veri', 'username'));
    }
    ///////////////////////////////////////////////////Atualiza Cliente//////////////////////////////////////////////////////////

    public function update(Request $request, $id)
    {
        date_default_timezone_set('America/Sao_Paulo');
        $nome_cli = $request->get('nome_cli');
        $cpf_cli = $request->get('cpf_cli');
        $rg_cli = $request->get('rg_cli');
        $estadocivil_cli = $request->get('estadocivil_cli');
        $nacionalidade_cli = $request->get('nacionalidade_cli');
        $profissao_cli = $request->get('profissao_cli');
        $nascimento_cli = $request->get('nascimento_cli');
        $email_cli = $request->get('email_cli');
        $obs_cli = $request->get('obs_cli');
        $estado_cli = $request->get('estado_cli');
        $senha = $request->get('senha');
        $idgrupo = $request->get('idgrupo') ?: '0';
        $imob_id = $request->get('imob_id') ?: '0';
        $creci = $request->get('creci') ?: '0';
        $insc_municipal = $request->get('insc_municipal') ?: '0';
        $cadastrado_por = $request->get('cadastrado_por');
        $data_cadastro = date('Y-m-d H:i:s');
        $alterado_por = $request->get('alterado_por') ?: '0';
        $data_alterado = date('Y-m-d H:i:s');
        $fisico_juridico = $request->get('pessoa');
        $categoria_cliente = $request->get('idgrupo_cliente');
        $cargo = $request->get('cargo');
        $salario_base = $request->get('salario_base');
        $data_contratacao = $request->get('data_contratacao');
        $data_demissao = $request->get('data_demissao');
        $foto_cli = $request->get('foto_cli');
        $cpf_rfb = $request->get('cpf_rfb');
        $renda_total = $request->get('renda_total');
        $orgao_expedidor = $request->get('orgao_expedidor');
        $interesse_empreendimento = $_POST['idempreendimento_cadastro'] ?: '0';
        $interesse_corretor = $_POST['imob_id'] ?: '0';
        $conta_id = $request->get('conta_id');
        $created_at = date('Y-m-d H:i:s');
        $updated_at = date('Y-m-d H:i:s');
        $path_foto =  $request->get('perfil_foto');


        // if (request()->hasFile('perfil_foto')) {
        //     $path_foto = $request->file('perfil_foto');
        //     $imageName = rand() . '.' . $path_foto->getClientOriginalExtension();
        //     $destinationPath = storage_path('/img/perfil');
        //     $path_foto->move($destinationPath, $imageName);
        //     $path_foto->perfil_foto = $destinationPath . $imageName;
        //     dd($path_foto);
        // } else {
        //     $path_foto = $request->file('perfil_foto');
        // };


        if ($request->hasFile('perfil_foto') && $request->file('perfil_foto')->isValid()) {

            $name = uniqid(date('HisYmd'));
            $extension = $request->perfil_foto->extension();
            $path_foto = "{$name}.{$extension}";
            $upload = $request->perfil_foto->storeAs('img/perfil', $path_foto);
        }
        if ($path_foto != '') {
            $update_img_user = DB::update("UPDATE users SET path_foto = '$path_foto' WHERE id = $cadastrado_por");
            $update_cli_img = DB::update("UPDATE cliente SET path_foto = '$path_foto' WHERE idcliente = $id");
        }

        $update_cli = DB::update("UPDATE cliente SET nome_cli = '$nome_cli', rg_cli = '$rg_cli', insc_municipal = '$insc_municipal', orgao_expedidor = '$orgao_expedidor', email_cli= '$email_cli', senha= '$senha', idgrupo= $idgrupo,
        categoria_cliente= $categoria_cliente,renda_total='$renda_total',nascimento_cli= '$nascimento_cli', data_alterado = '$updated_at', nacionalidade_cli='$nacionalidade_cli', cargo = '$profissao_cli', obs_cli = '$obs_cli' ,updated_at='$updated_at'
        where idcliente = $id ");

        $rua  = $request->get("modal_endereco1");
        $cep  = $request->get("modal_cep1");
        $numero = $request->get("modal_numero1");
        $complemento = $request->get("modal_complemento1");
        $bairro = $request->get("modal_bairro1");
        $cidade = $request->get("modal_cidade1");
        $estado = $request->get("modal_estado1");

        $resultado = array('rua' => $rua, 'cep' => $cep, 'numero' => $numero, 'complemento' => $complemento, 'bairro' => $bairro, 'cidade' => $cidade, 'estado' => $estado);

        if ($cep != '') {
            $update_end = DB::update("UPDATE endereco_cli SET endereco_cli = '$rua', numero_cli = '$numero', complemento_cli = '$complemento',
        bairro_cli = '$bairro', cidade_cli = '$cidade', estado_cli = '$estado', cep_cli = '$cep' WHERE id_cliente = $id  ");
        }



        $celular = $request->get("modal_celular1");

        $telFixo = $request->get("modal_telfixo1");

        $telComercial = $request->get("modal_telcomercial1");



        $res = array('celular' => $celular, 'telfixo' => $telFixo, 'telcomercial' => $telComercial);

        if ($celular != '') {
            $updateTel = DB::update("UPDATE telefone_cli SET celular = '$celular', telefone_fixo = '$telFixo', telefone_comercial = '$telComercial' WHERE id_cliente = $id ");
        }

        $delTipo = DB::delete("DELETE FROM cliente_tipo where idcliente = $id");

        $id_cad = $request->get("tipo_cliente");

        if (!empty($id_cad)) {
            foreach ($id_cad as $tipo) {

                $insTipo = DB::insert("INSERT INTO cliente_tipo (idcliente, idtipo)
            values
            ($id,$tipo)
            ");
            }
        }


        $username =  Auth::user($cadastrado_por)->name;
        $datalog = date('Y-m-d H:i:s');
        $usuario_id = $cadastrado_por;
        $descricao_log = "Usuário " . $username . " editou um cliente: " . $nome_cli;

        $gravaLog = DB::insert("INSERT INTO log(data_log,usuario_id,descricao_log)
                values('$datalog',$usuario_id,'$descricao_log')");

        if ($update_cli) {
            return redirect('clientes')->with('success', 'Cliente alterado com sucesso!');

        } else {
            return redirect()->back()->with('error', 'Não foi possivel alterar seus dados! Revise os campos e tente novamente');

        }
    }
    ///////////////////////////////////////////////////Atualiza Endereço//////////////////////////////////////////////////////////
    public function atualizaEndereco(Request $request)
    {

        $rua  = $_POST["rua"];
        $cep  = $_POST["cep"];
        $numero = $_POST["numero"];
        $complemento = $_POST["complemento"];
        $bairro = $_POST["bairro"];
        $cidade = $_POST["cidade"];
        $estado = $_POST["estado"];

        $resultado = array('rua' => $rua, 'cep' => $cep, 'numero' => $numero, 'complemento' => $complemento, 'bairro' => $bairro, 'cidade' => $cidade, 'estado' => $estado);



        if ($rua != "" && $cep != "" && $numero != "" && $bairro != "" && $cidade != "" && $estado != "") {

            echo json_encode($resultado);
        }
    }

    public function atualizaTelefone(Request $request)
    {

        $celular = $_POST["celular"];

        $telFixo = $_POST["telfixo"];

        $telComercial = $_POST["telcomercial"];



        $res = array('celular' => $celular, 'telfixo' => $telFixo, 'telcomercial' => $telComercial);



        echo json_encode($res);
    }
    /**
     * Remove the specified resource from storage.
     * 
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {

        $nome_cli = DB::select("SELECT nome_cli, cadastrado_por FROM cliente where idcliente = $id");
        foreach ($nome_cli as $nm) {
            $nome =  $nm->nome_cli;
            $cadastrado_por = $nm->cadastrado_por;
        }
        $username =  Auth::user($cadastrado_por)->name;
        $datalog = date('Y-m-d H:i:s');
        $usuario_id = $cadastrado_por;
        $descricao_log = "Usuário " . $username . " excluiu cliente: " . $nome;

        $gravaLog = DB::insert("INSERT INTO log(data_log,usuario_id,descricao_log)
                values('$datalog',$usuario_id,'$descricao_log')");


        // $d =  ClienteModel::where('idcliente', $id)->delete();
        $deleta = DB::delete("DELETE FROM cliente where idcliente = $id");
        $deletaEnd = DB::delete("DELETE FROM endereco_cli where id_cliente = $id");
        $deletaTel = DB::delete("DELETE FROM telefone_cli where id_cliente = $id");
        $deletaTip = DB::delete("DELETE FROM cliente_tipo where idcliente = $id");


        // return redirect('clientes')->with('success', 'Cliente deletado com sucesso!');
    }
}
