<?php

namespace App\Http\Controllers;

use App\CadastroModel;
use App\ClienteModel;
use App\ClienteTipoModel;
use App\EmpreendimentoCadModel;
use App\GrupoClienteModel;
use App\grupoModel;
use App\TipoClienteModel;
use App\TelefoneCliModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use mysqli;
use PhpParser\Node\Expr\FuncCall;

class CadastroClienteController extends Controller
{

    public function __construct(CadastroModel $cadastroModel)
    {
        $this->middleware('auth');
        $this->cadastroModel = $cadastroModel;
    }

    ///////////////////////////////////////////////////View Cadastro Geral//////////////////////////////////////////////////////////

    public function cadastro(
        GrupoModel $grupoModel,
        GrupoClienteModel $grupoClienteModel,
        TipoClienteModel $tipoClienteModel,
        ClienteModel $clienteModel,
        EmpreendimentoCadModel $empreendimentoCadModel,
        ClienteTipoModel $clienteTipoModel
    ) {
        $grupo = $grupoModel->all();
        $grupoCliente = $grupoClienteModel->all();
        $tipoCliente =  DB::select("SELECT * FROM tipo_cliente ORDER BY descricao_tipo");
        $cliente =  DB::select("SELECT * FROM cliente
            INNER JOIN cliente_tipo ON cliente.idcliente = cliente_tipo.idcliente 
            where cliente_tipo.idtipo = 11  order by nome_cli Asc");
        $empreendimentoCad = $empreendimentoCadModel->all();
        $clienteTipo =  $clienteTipoModel->all();

        return view('cliente/cadastro_cliente', compact('grupo', 'grupoCliente', 'tipoCliente', 'cliente', 'empreendimentoCad', 'clienteTipo'));
    }
    ///////////////////////////////////////////////////Cria cadastro//////////////////////////////////////////////////////////

    public function cadastrar(Request $request)
    {
        $id = Auth::user()->id;
        $user = auth()->user();
        date_default_timezone_set('America/Sao_Paulo');
        $nome_cli = $request->get('nome_cli');
        $cpf_cli = $request->get('cpf_cli');
        $rg_cli = $request->get('rg_cli');
        $estadocivil_cli = $request->get('estadocivil_cli');
        $nacionalidade_cli = $request->get('nacionalidade_cli');
        $profissao_cli = $request->get('profissao_cli');
        $nascimento_cli = $request->get('nascimento_cli');
        $email_cli = $request->get('email_cli');
        $obs_cli = $request->get('obs_cli');
        $estado_cli = $request->get('estado_cli');
        $senha = $request->get('senha');
        // $idgrupo = $request->get('idgrupo') ? '' : '0';
        $idgrupo = $request->get('idgrupo') ?: '0';
        $imob_id = $request->get('imob_id') ?: '0';
        $creci = $request->get('creci') ?: '0';
        $insc_municipal = $request->get('insc_municipal') ?: '0';
        $cadastrado_por = $request->get('cadastrado_por');
        $data_cadastro = date('Y-m-d H:i:s');
        $alterado_por = $request->get('alterado_por') ?: '0';
        $data_alterado = $request->get('data_alterado');
        $fisico_juridico = $request->get('pessoa');
        $categoria_cliente = $request->get('idgrupo_cliente');
        $cargo = $request->get('cargo');
        $salario_base = $request->get('salario_base');
        $data_contratacao = $request->get('data_contratacao');
        $data_demissao = $request->get('data_demissao');
        $foto_cli = $request->get('foto_cli');
        $cpf_rfb = $request->get('cpf_rfb');
        $renda_total = $request->get('renda_total');
        $path_foto = $request->get('perfil_foto');
        $orgao_expedidor = $request->get('orgao_expedidor');
        $interesse_empreendimento = $_POST['idempreendimento_cadastro'] ?: '0';
        $interesse_corretor = $_POST['imob_id'] ?: '0';
        $conta_id = $request->get('conta_id');
        $created_at = date('Y-m-d H:i:s');
        $updated_at = date('Y-m-d H:i:s');
        // $updated_at = $request ->get('updated_at')? '': '0000-00-00 00:00:00';

        if ($request->hasFile('perfil_foto') && $request->file('perfil_foto')->isValid()) {
            $name = uniqid(date('HisYmd'));
            $extension = $request->perfil_foto->extension();
            $path_foto = "{$name}.{$extension}";
            $upload = $request->perfil_foto->storeAs('img/perfil', $path_foto);
        }


        $cria = DB::insert("INSERT INTO cliente (
        nome_cli,
        cpf_cli,
        rg_cli,
        estadocivil_cli,
        nacionalidade_cli,
        profissao_cli,
        nascimento_cli,
        email_cli,
        obs_cli,
        estado_cli,
        senha,
        idgrupo,
        imob_id,
        creci,
        insc_municipal,
        cadastrado_por,
        data_cadastro,
        alterado_por,
        data_alterado,
        fisico_juridico,
        categoria_cliente,
        cargo,
        salario_base,
        data_contratacao,
        data_demissao,
        foto_cli,
        cpf_rfb,
        renda_total,
        path_foto,
        orgao_expedidor,
        interesse_empreendimento,
        interesse_corretor,
        conta_id,
        created_at,
        updated_at)

        VALUES (
        '$nome_cli',
        '$cpf_cli',
        '$rg_cli',
        '$estadocivil_cli',
        '$nacionalidade_cli',
        '$profissao_cli',
        '$nascimento_cli',
        '$email_cli',
        '$obs_cli',
        '$estado_cli',
        '$senha',
        $idgrupo,
        $imob_id,
        '$creci',
        '$insc_municipal',
        $cadastrado_por,
        '$data_cadastro',
         $alterado_por,
        '$data_alterado',
        $fisico_juridico,
        $categoria_cliente,
        '$cargo',
        '$salario_base',
        '$data_contratacao',
        '$data_demissao',
        '$foto_cli',
        '$cpf_rfb',
        '$renda_total',
        '$path_foto',
        '$orgao_expedidor',
        $interesse_empreendimento,
        $interesse_corretor,
        $id,
        '$created_at',
        '$updated_at')");


        $id_convertido = DB::getPdo()->lastInsertId();



        $celular = $request->get("modal_celular1");

        $telFixo = $request->get("modal_telfixo1");

        $telComercial = $request->get("modal_telcomercial1");



        $res = array('celular' => $celular, 'telfixo' => $telFixo, 'telcomercial' => $telComercial);


        $cadTel =  DB::insert("INSERT INTO telefone_cli (id_cliente, celular,telefone_fixo, telefone_comercial) VALUES
            ($id_convertido,'$celular','$telFixo','$telComercial')");


        $rua  = $request->get("modal_endereco1");
        $cep  = $request->get("modal_cep1");
        $numero = $request->get("modal_numero1");
        $complemento = $request->get("modal_complemento1");
        $bairro = $request->get("modal_bairro1");
        $cidade = $request->get("modal_cidade1");
        $estado = $request->get("modal_estado1");

        $resultado = array('rua' => $rua, 'cep' => $cep, 'numero' => $numero, 'complemento' => $complemento, 'bairro' => $bairro, 'cidade' => $cidade, 'estado' => $estado);

        $query = DB::insert("INSERT INTO endereco_cli (id_cliente, endereco_cli, numero_cli, complemento_cli, bairro_cli, cidade_cli, estado_cli, cep_cli)  
        VALUES('$id_convertido', '$rua', '$numero','$complemento', '$bairro', '$cidade', '$estado', '$cep')");

        $id_cad = $request->get("tipo_cliente");

        foreach ($id_cad as $tipo) {

            $cadTipo = DB::insert("INSERT INTO cliente_tipo (idcliente, idtipo)
            values
            ($id_convertido,$tipo)
            ");
        }

        $username =  Auth::user($cadastrado_por)->name;
        $datalog = date('Y-m-d H:i:s');
        $usuario_id = $cadastrado_por;
        $descricao_log = "Usuário " . $username . " cadastrou um novo cliente: " . $nome_cli;

        $gravaLog = DB::insert("INSERT INTO log(data_log,usuario_id,descricao_log)
                values('$datalog',$usuario_id,'$descricao_log')");

        $id_conj_ajax = $request->get("conjuge_idconjuge");
        if ($id_conj_ajax != '') {
            $vinculaconj = DB::insert("INSERT INTO conjuge (cliente_idcliente, conjuge_idconjuge) values ($id_convertido,$id_conj_ajax)");

            return redirect('cadastro_cliente')->with('success', 'Cadastro realizado com sucesso!');
        } else {

            return redirect('cadastro_cliente')->with('success', 'Cadastro realizado com sucesso!');
        }
    }
    ///////////////////////////////////////////////////Cria Telefone//////////////////////////////////////////////////////////

    public function cadTelefone(Request $request)
    {


        $celular = $_POST["celular"];

        $telFixo = $_POST["telfixo"];

        $telComercial = $_POST["telcomercial"];



        $res = array('celular' => $celular, 'telfixo' => $telFixo, 'telcomercial' => $telComercial);



        echo json_encode($res);
    }
    ///////////////////////////////////////////////////Recebe Endereço ajax//////////////////////////////////////////////////////////

    function recebeEndereco(Request $request)
    {

        $rua  = $_POST["rua"];
        $cep  = $_POST["cep"];
        $numero = $_POST["numero"];
        $complemento = $_POST["complemento"];
        $bairro = $_POST["bairro"];
        $cidade = $_POST["cidade"];
        $estado = $_POST["estado"];

        $resultado = array('rua' => $rua, 'cep' => $cep, 'numero' => $numero, 'complemento' => $complemento, 'bairro' => $bairro, 'cidade' => $cidade, 'estado' => $estado);



        if ($rua != "" && $cep != "" && $numero != "" && $bairro != "" && $cidade != "" && $estado != "") {

            echo json_encode($resultado);
        }
    }
    ///////////////////////////////////////////////////Recebe CEP Ajax//////////////////////////////////////////////////////////

    function recebeCep(Request $request)
    {
        // dd($request);
        $cep = $_POST['cep'];

        $reg = simplexml_load_file("http://cep.republicavirtual.com.br/web_cep.php?formato=xml&cep=" . $cep);

        $dados['sucesso'] = (string) $reg->resultado;
        $dados['rua']     = (string) $reg->tipo_logradouro . ' ' . $reg->logradouro;
        $dados['bairro']  = (string) $reg->bairro;
        $dados['cidade']  = (string) $reg->cidade;
        $dados['estado']  = (string) $reg->uf;

        echo json_encode($dados);
    }
    ///////////////////////////////////////////////////Cria Conjuge//////////////////////////////////////////////////////////

    public function cadConjuge(Request $request)
    {

        $id = Auth::user()->id;
        date_default_timezone_set('America/Sao_Paulo');
        $nome_conj = $request->get("nome_conj");
        $cpf_conj = $request->get("cpf_conj");
        $rg_conj = $request->get("rg_conj");
        $estadocivil_cli = $request->get('estadocivil_cli');
        $nacionalidade_conj = $request->get("nacionalidade_conj");
        $profissao_conj = $request->get("profissao_conj");
        $nascimento_conj = $request->get("nascimento_conj");
        $email_cli = $request->get('email_conj');
        $obs_cli = $request->get('obs_cli');
        $estado_cli = $request->get('estado_cli') ? '' : '0';
        $senha = $request->get('senha');
        // $idgrupo = $request->get('idgrupo') ? '' : '0';
        $idgrupo = $request->get('idgrupo') ?: '0';
        $imob_id = $request->get('imob_id') ?: '0';
        $creci = $request->get('creci') ?: '0';
        $insc_municipal = $request->get('insc_municipal') ?: '0';
        $cadastrado_por = $request->get('cadastrado_por') ?: '0';
        $data_cadastro = date('Y-m-d H:i:s');
        $alterado_por = $request->get('alterado_por') ?: '0';
        $data_alterado = $request->get('data_alterado');
        $fisico_juridico = $request->get('pessoa') ?: '0';
        $categoria_cliente = $request->get('idgrupo_cliente') ?: '0';
        $cargo = $request->get('cargo');
        $salario_base = $request->get('salario_base');
        $data_contratacao = $request->get('data_contratacao');
        $data_demissao = $request->get('data_demissao');
        $foto_cli = $request->get('foto_cli');
        $cpf_rfb = $request->get('cpf_rfb');
        $renda_total = $request->get('renda_total');
        $path_foto = $request->get('perfil_foto');
        $orgao_con_expedidor = $request->get("orgao_con_expedidor");
        $interesse_empreendimento = $request->get('crecinteresse_empreendimentoi') ? '' : '0';
        $interesse_corretor = $request->get('interesse_corretor') ? '' : '0';
        $interesse_corretor = '0';
        $conta_id = $request->get('conta_id') ? '' : '0';
        $created_at = date('Y-m-d H:i:s');
        $updated_at = date('Y-m-d H:i:s');
        $telefone1 = $request->get("telefone1_conj");
        $telefone2 = $request->get("telefone3_conj");
        $telefone3 = $request->get("telefone2_conj");

        if ($nascimento_conj != "") {
            $nascimento_conj = date("Y-m-d", strtotime($nascimento_conj));
        }

        $insereconj = DB::insert("INSERT INTO cliente (
        nome_cli,
        cpf_cli,
        rg_cli,
        estadocivil_cli,
        nacionalidade_cli,
        profissao_cli,
        nascimento_cli,
        email_cli,
        obs_cli,
        estado_cli,
        senha,
        idgrupo,
        imob_id,
        creci,
        insc_municipal,
        cadastrado_por,
        data_cadastro,
        alterado_por,
        data_alterado,
        fisico_juridico,
        categoria_cliente,
        cargo,
        salario_base,
        data_contratacao,
        data_demissao,
        telefone1_cli,
        telefone2_cli,
        telefone3_cli,
        foto_cli,
        cpf_rfb,
        renda_total,
        path_foto,
        orgao_expedidor,
        interesse_empreendimento,
        interesse_corretor,
        conta_id,
        created_at,
        updated_at)

        VALUES (
        '$nome_conj',
        '$cpf_conj',
        '$rg_conj',
        '$estadocivil_cli',
        '$nacionalidade_conj',
        '$profissao_conj',
        '$nascimento_conj',
        '$email_cli',
        '$obs_cli',
        '$estado_cli',
        '$senha',
        $idgrupo,
        $imob_id,
        '$creci',
        '$insc_municipal',
        $cadastrado_por,
        '$data_cadastro',
        $alterado_por,
        '$data_alterado',
        1,
        $categoria_cliente,
        '$cargo',
        '$salario_base',
        '$data_contratacao',
        '$data_demissao',
        '$telefone1',
        '$telefone2',
        '$telefone3',
        '$foto_cli',
        '$cpf_rfb',
        '$renda_total',
        '$path_foto',
        '$orgao_con_expedidor',
        $interesse_empreendimento,
        $interesse_corretor,
        $id,
        '$created_at',
        '$updated_at')");


        $ultimo_id = DB::getPdo()->lastInsertId();


        $insereTelConj = DB::insert("INSERT INTO telefone_cli(id_cliente, celular, telefone_fixo, telefone_comercial) 
        VALUES($ultimo_id, '$telefone1', '$telefone3' , '$telefone2')");

        $idtipo = 6;

        $insert_cliente_tipo = DB::insert("INSERT INTO cliente_tipo ( idcliente, idtipo )  values( $ultimo_id,'$idtipo' )");

        $ultimo = DB::select("SELECT * FROM cliente ORDER BY idcliente DESC LIMIT 1");


        echo json_encode($ultimo);
    }
    ///////////////////////////////////////////////////Consulta CPF AJAX//////////////////////////////////////////////////////////

    public function consultaCpf(Request $request)
    {

        function busca_grupo($idgrupo)
        {
            $query_slide = DB::select("SELECT * FROM grupo_cliente WHERE idgrupo_cliente = $idgrupo");

            foreach ($query_slide as $busc) {
                $descricao_grupo_cliente  = $busc->descricao;
            }
            return $descricao_grupo_cliente;
        }

        $cpf = $_POST['cpf'];

        $query_amigo = DB::select("SELECT sum(idcliente) as TOTAL, categoria_cliente FROM cliente                		
                                 where cpf_cli = '$cpf'") or die("Erro ao listar empreendimento");


        foreach ($query_amigo as $res) {

            $idcliente = $res->TOTAL;
            $categoria_cliente = $res->categoria_cliente;

            $ress[] = array('TOTAL' => $idcliente, 'categoria_cliente' => $categoria_cliente);
            if ($categoria_cliente != '') {
                $categoria_cliente =  busca_grupo($categoria_cliente);
            } else {
                $categoria_cliente = '0';
            }
        }
        if ($idcliente == '') {

            $dados['sucesso'] = 2;
            $dados['categoria_cliente'] = $categoria_cliente;
        } else {
            $dados['sucesso'] = 1;
            $dados['categoria_cliente'] = $categoria_cliente;
        }

        echo json_encode($dados);
    }
}
